% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_proportional_error_model}
\alias{set_proportional_error_model}
\title{set_proportional_error_model}
\usage{
set_proportional_error_model(
  model,
  dv = NULL,
  data_trans = NULL,
  zero_protection = TRUE
)
}
\arguments{
\item{model}{(Model) Set error model for this model}

\item{dv}{(str or Expr or numeric (optional)) Name or DVID of dependent variable. NULL for the default (first or only)}

\item{data_trans}{(numeric or str or Expr (optional)) A data transformation expression or NULL (default) to use the transformation
specified by the model.}

\item{zero_protection}{(logical) Set to TRUE to add code protecting from IPRED=0}
}
\value{
(Model) Pharmpy model object
}
\description{
Set a proportional error model. Initial estimate for new sigma is 0.09.

The error function being applied depends on the data transformation.

+------------------------+----------------------------------------+
| Data transformation    | Proportional error                     |
+========================+========================================+
| (equation could not be rendered, see API doc on website)
+------------------------+----------------------------------------+
| (equation could not be rendered, see API doc on website)
+------------------------+----------------------------------------+
}
\examples{
\dontrun{
model <- remove_error_model(load_example_model("pheno"))
model <- set_proportional_error_model(model)
model$statements$after_odes
model <- remove_error_model(load_example_model("pheno"))
model <- set_proportional_error_model(
 model,
 data_trans="log(Y)"
model$statements$after_odes
}
}
\seealso{
set_additive_error_model : Additive error model

set_combined_error_model : Combined error model
}
