% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{cleanup_model}
\alias{cleanup_model}
\title{cleanup_model}
\usage{
cleanup_model(model)
}
\arguments{
\item{model}{(Model) Pharmpy model object}
}
\value{
(Model) Updated model
}
\description{
Perform various cleanups of a model

This is what is currently done
\itemize{
\item Make model statements declarative, i.e. only one assignment per symbol
\item Inline all assignments of one symbol, e.g. X = Y
\item Remove all random variables with no variability (i.e. with omegas fixed to zero)
\item Put fixed thetas directly in the model statements
}
}
\note{
When creating NONMEM code from the cleaned model Pharmpy might need toadd certain assignments to make it in line with what NONMEM requires.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model$statements
model <- cleanup_model(model)
model$statements
}
}
