% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grvi.r
\name{grvi}
\alias{grvi}
\title{Calculate green-red vegetation index (GRVI)}
\usage{
grvi(data, par = c(1, 1, 1), internal = TRUE, out_dir = tempdir())
}
\arguments{
\item{data}{a PhenoCam data file or data frame (when using a file provide a
full path if not in the current working directory)}

\item{par}{grvi parameters (digital number weights)}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data}
}
\value{
Inserts a GRVI data column into the provided PhenoCam
data structure or file.
}
\description{
The GRVI is defined as the normalized ratio between the red and green channel
of a RGB image or digital number triplet. However, the blue channel can be
used as well using a weighting factor. As such a paramter vector is provided
so different channels / DN can be weighted separately.
}
\examples{

\donttest{
# with defaults, outputting a data frame
# with smoothed values, overwriting the original

# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1",
                  frequency = "3")

# calculate and append the GRVI for a file (overwrites the original)
grvi(paste0(tempdir(),"/harvard_DB_0001_3day.csv"))

# as all functions this also works on a PhenoCam data structure
df <- read_phenocam(paste0(tempdir(),"/harvard_DB_0001_3day.csv"))
df <- grvi(df, par = c(1, 1, 0))
}
}
\keyword{colour}
\keyword{index,}
\keyword{phenocam}
\keyword{series,}
\keyword{time}
