#' phenology is the help function for phenology package.
#' @title The function "phenology"
#' @author Marc Girondot
#' @return None
#' @description Help function for phenology package.
#' @export


phenology <-
function() {
	cat("Version 3.25 25/3/2012\n")
	cat("----------------------------------------------------------------------------------\n")
	cat("The current working directory is:\n")
	wd<-getwd()
	cat(wd, "\n\n")

	cat("Help is available for each function with function_name(help=TRUE)\n")
	cat("\n")

	repeat {

	cat("\n")
	cat("The different functions to be used are:\n")
	cat("1:  Change the working directory:\n")
	cat("    setwd('", wd, "')\n", sep="")
	cat("2:  This help\n")
	cat("    phenology()\n")
	cat("3:  Demo data. Generate a 'Gratiot' variable to play with.\n")
	cat("    The data come from Gratiot et al. 2006 fig. 1a.\n")
	cat("4:  Read data from file:\n")
	cat("    newdata<-read.delim('Essai.txt', , header=FALSE) \n")
	cat("5:  Format data to be analyzed:\n")
	cat("    data<-add_format(origin=previousdata, add=newdata, name='Site', \n")
	cat("    + reference=as.Date('2001-01-01'), format='%d/%m/%y')\n")
	cat("6:  Estimate first set of initial values:\n")
	cat("    par<-par_init(data=dta, parametersfixed=parfixed)\n")
	cat("7:  Estimate likelihood:\n")
	cat("    Likelihood_phenology(data=dta, parametersfit=x, parametersfixed=parfixed,\n")
	cat("    + method_incertitude=2)\n")
	cat("8:  Transform a set of parameters from Begin and End to LengthB and LengthE:\n")
	cat("    para<-BE_to_LBLE(parameters=para)\n")
	cat("9:  Transform a set of parameters from LengthB and LengthE to Begin and End:\n")
	cat("    para<-LBLE_to_BE(parameters=para)\n")
	cat("10: Fit the data:\n")
	cat("    res<-fit_phenology(data=dta, parametersfit=x, parametersfixed=parfixed,\n")
	cat("    + method_incertitude=2, trace=1, zero_counts=c(TRUE), hessian=TRUE)\n")
	cat("11: Plot the nth timeseries (data is optional if result is indicated):\n")
	cat("    plot_phenology(result=res, data=dta, pdf=TRUE, series=n)\n")
	cat("12: Take the fitted parameters from a fitted result:\n")
	cat("    para<-extract_result(result=res)\n")
	cat("13: Remove the site information from the name of parameters:\n")
	cat("    para<-remove_site(parameters=para)\n")
	cat("14: Add standard deviation for a fixed parameter.\n")
	cat("    parfixed<-add_SD(parametersfixed=NULL, parameter=name, SD=value)\n")
	cat("15: Generate a likelihood map varying Phi and Delta.\n")
	cat("    Lmap<-map_phenology(data=dta, parametersfit=x, parametersfixed=parfixed,\n")
	cat("    + Phi=seq(from=0.2,to=20, length.out=100), method_incertitude=2, zero_counts=TRUE)\n")
	cat("16: Plot the map generated by map_phenology()\n")
	cat("    plot_map(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")	
	cat("17: Plot the -Ln L according to Phi value for a map\n")
	cat("    plot_phi(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")
	cat("18: Plot the -Ln L according to Delta value for a map\n")
	cat("    plot_delta(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")
	cat("19: This function is used to shift sinusoid parameters from '', '1' or '2'.\n")
	cat("    par<-shift_sinusoid(parameters=parx, from='', to='1')\n")
	cat("\nEnter the number of the function to be used (1, 3, 4, 8, 9, 12, 13, 14): ")
	
	
	
	f<-scan(nmax=1, quiet=TRUE)
	
	if(length(f)!=0) {
#####################################################################
		if(f==1) {
			cat("1: setwd()\n")
			cat("Working directory:\n")
			p<-scan(nmax=1, what="character", allowEscapes=TRUE, sep="*", quiet=TRUE)
			if(length(p)!=0) {
				setwd(p)
				wd<-getwd()
				print("Done !")
			}
		}
#####################################################################
		if(f==4) {
			cat("4: newdata<-read.delim('Essai.txt', , header=FALSE) \n")
			cat("Name of the file to be read:\n")
			nm<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(nm)!=0) {
				cat("Name of data in which the file will be read:\n")
				dta<-scan(nmax=1, what="character", quiet=TRUE)
				if(length(dta)!=0) {
					cat("Have the data a header (Y/N [default]):\n")
					hed<-scan(nmax=1, what="character", quiet=TRUE)
					if(length(hed)==0) {hed<-"N"}
					hedF<-ifelse(hed=="Y", TRUE, FALSE)
					assign(dta, read.delim(nm, , header=hedF), envir = .GlobalEnv)
					print("Done !")
				}			
				
			}
		}
#####################################################################
		if(f==8) {
			cat("8: para<-BE_to_LBLE(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, BE_to_LBLE(parameters=eval(as.name(p))), envir = .GlobalEnv)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}
#####################################################################
		if(f==9) {
			cat("9: para<-LBLE_to_BE(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, LBLE_to_BE(parameters=eval(as.name(p))), envir = .GlobalEnv)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}
#####################################################################
		if(f==12) {
			cat("12: para<-extract_result(result=res)\n")
			cat("Result data to be used:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
			 		cat("Parameters data to be setup:\n")
			 		q<-scan(nmax=1, what="character")
					if(length(q)!=0) {
						assign(q, extract_result(result=eval(as.name(p))), envir = .GlobalEnv)
						print("Done !")
					}
				} else {
					print("The results do not exist.")
				}
			}
		}
#####################################################################
		if(f==13) {
			cat("13: para<-remove_site(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, remove_site(parameters=eval(as.name(p))), envir = .GlobalEnv)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}

#####################################################################
		if(f==14) {
			cat("14: parfixed<-add_SD(parametersfixed=NULL, parameter=name, SD=value)\n")
			cat("Fixed parameters to be changed:\n")
			pf<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(pf)!=0) {
				es<-try(eval(as.name(pf)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
			 		cat("The fixed parameters are:\n", sep=" ")
					cat(names(es), "\n", sep=" ")
					cat("Name of the parameter to add a SD value:\n")
					npf<-scan(nmax=1, what="character", quiet=TRUE)
					if(length(npf)!=0) {
			 			if(any(names(es)==npf)) {
			 				cat("SD value:\n")
			 				sd<-scan(nmax=1, what="numeric", quiet=TRUE)
							if(length(sd)!=0) {
								sd<-as.numeric(sd)
								es<-add_SD(parametersfixed=es, parameter=npf, SD=sd)
								assign(pf, es, envir = .GlobalEnv)
								print("Done !")
							}
						} else {
							print("The parameter does not exist.")
						}
					}
				} else {
					print("The parameters list do not exist.")
				}
			}
		}

#####################################################################
		if(f==2) {
			#source('http://www.ese.u-psud.fr/epc/conservation/BI/Source_Phenology.r')
			#print("Done !")
		}
		
		

#####################################################################
		if(f==3) {

Gratiot<<-data.frame(
V1=format(seq(from=as.Date("2001-01-01"), to=as.Date("2001-12-31"), by="1 day"), "%d/%m/%Y")
, V2=c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 
0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 1, 2, 4, 8, 7, 2, 5, 0, 1, 0, 0, 8, 1, 2, 5, 3, 
7, 2, 4, 8, 4, 6, 15, 5, 7, 20, 6, 4, 10, 9, 3, 11, 14, 12, 10, 
14, 7, 7, 2, 1, 15, 26, 30, 43, 20, 5, 43, 25, 19, 20, 28, 26, 
31, 18, 25, 10, 17, 5, 17, 33, 26, 41, 30, 20, 55, 16, 17, 9, 
20, 76, 31, 55, 62, 46, 29, 48, 45, 56, 47, 45, 22, 35, 39, 22, 
11, 25, 20, 27, 45, 80, 48, 44, 19, 33, 19, 7, 34, 36, 22, 23, 
31, 13, 13, 17, 26, 36, 15, 24, 26, 41, 26, 35, 25, 10, 13, 10, 
25, 18, 10, 22, 35, 29, 11, 10, 7, 3, 4, 6, 6, 5, 9, 9, 6, 9, 
10, 1, 0, 3, 4, 0, 0, 1, 1, 1, 4, 0, 1, 1, 1, 1, 2, 0, 0, 2, 
2, 0, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0, 0, 0, 0, 0, 0, 
2, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 1, 0, 3, 0, 0, 0, 0, 1, 3, 3, 0, 
1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 0, 1, 2)
)

cat('> Gratiot<-read.delim("http://www.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)\n')
cat("# The demo data are in the Gratiot variable.\n")
cat("# They come from the figure 1 of:\n")
cat("# Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. (2006) Estimation of marine turtles nesting season from incomplete data ; statistical adjustment of a sinusoidal function. Animal Conservation, 9, 95-102.\n")

cat('> data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="%d/%m/%Y")', "\n")
data_Gratiot<<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="%d/%m/%Y")
cat('> par<-par_init(data_Gratiot, parametersfixed=NULL)\n')
# par<<-par_init(data_Gratiot, parametersfixed=NULL)
par<<-structure(c(95.8321263398564, 175.358708794243, 62.4612122478645, 
8.05881177534446e-05, 33.0763701906086, 0.217617932254042, 0.424402045435138, 
3.58256503707858), .Names = c("LengthB", "Peak", "LengthE", "Flat", 
"Max_Complete", "MinB_Complete", "MinE_Complete", "Theta"))
cat('> result<-fit_phenology(data=data_Gratiot, parametersfit=par, parametersfixed=NULL, trace=0)\n')
result_Gratiot<<-fit_phenology(data=data_Gratiot, parametersfit=par, parametersfixed=NULL, trace=0)
cat('> plot_phenology(result=result, pdf=FALSE)\n')
plot_phenology(result=result_Gratiot, pdf=FALSE)
			print("Done !")
		}
		
#####################################################################


		if(f==0) {
			# source('/Users/marcgirondot/Documents/Espace de travail R/Phenology/Source fit/Source_Phenology.r')
			# print("Done !")
		}
		
		
#####################################################################

	} else {
	break()
	}
	
	}

}
