% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phonics.R
\name{phonics}
\alias{phonics}
\title{Phonetic Spelling Algorithms}
\usage{
phonics(word, method, clean = TRUE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{method}{vector of method names to use}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}
}
\value{
Returns a data frame containing the phonetic spellings of the input
for each method applied.
}
\description{
The \code{phonics} package for \code{R} is designed to provide a
variety of phonetic indexing algorithms in common and not-so-common
use today.  The algorithms generally reduce a string to a symbolic
representation approximating the sound made by pronouncing the
string.  They can be used to match names, strings, and as a proxy for
assorted string distance algorithms.  The algorithm reduces a string
to a symbolic representation approximating the sound.  It can be used
to match names, strings, and as a proxy for assorted string distance
algorithms.
}
\details{
The \code{phonics} package for \code{R} is designed to provide a
variety of phonetic indexing algorithms in common and not-so-common
use today.  The algorithms generally reduce a string to a symbolic
representation approximating the sound made by pronouncing the
string.  They can be used to match names, strings, and as a proxy for
assorted string distance algorithms.  The algorithm reduces a string
to a symbolic representation approximating the sound.  It can be used
to match names, strings, and as a proxy for assorted string distance
algorithms.

The variable \code{word} is a character string or a vector of
character strings to be encoded.

Different phonetic algorithm are only defined for inputs over the
limited alphabets, Non-alphabetical characters are removed from the
string in a locale-dependent fashion. This strips spaces, hyphens,
and numbers. For inputs outside of its known range, the output is
undefined and \code{NA} is returned and a warning this thrown. If
\code{clean} is \code{FALSE}, \code{phonics} attempts to process the
strings. The default is \code{TRUE}.

The \code{method} parameter should be a character vector containing one or
more methods that should be used. The available list of methods is
"caverphone", "caverphone.modified", "cologne", "lein", "metaphone",
"nysiis", "nysiis.modified", "onca", "onca.modified", "onca.refined",
"onca.modified.refined", "phonex", "rogerroot", "soundex",
"soundex.refined", and "statcan".
}
\examples{
phonics(c("Peter", "Peady"), c("soundex", "soundex.refined"))

}
\seealso{
Other phonics: 
\code{\link{caverphone}()},
\code{\link{cologne}()},
\code{\link{lein}()},
\code{\link{metaphone}()},
\code{\link{mra_encode}()},
\code{\link{nysiis}()},
\code{\link{onca}()},
\code{\link{phonex}()},
\code{\link{rogerroot}()},
\code{\link{soundex}()},
\code{\link{statcan}()}
}
\concept{phonics}
