% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.waveband.r
\name{trim_waveband}
\alias{trim_waveband}
\title{Trim (or expand) head and/or tail}
\usage{
trim_waveband(
  w.band,
  range = NULL,
  low.limit = 0,
  high.limit = Inf,
  trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = TRUE
)
}
\arguments{
\item{w.band}{an object of class "waveband" or a list of such objects.}

\item{range}{a numeric vector of length two, or any other object for which
function range() will return a numeric vector of two wavelengths (nm).}

\item{low.limit}{shortest wavelength to be kept (defaults to 0 nm).}

\item{high.limit}{longest wavelength to be kept (defaults to Inf nm).}

\item{trim}{logical (default is TRUE which trims the wavebands at the
boundary, while FALSE discards wavebands that are partly off-boundary).}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
The returned value is a waveband object or a list of waveband objects
  depending on whether a single waveband object or a list of waveband objects
  was supplied as argument to formal parameter \code{w.band}. If no waveband
  is retained, in the first case,  a NULL waveband object is returned, and in
  the second case, a list of length zero is returned. If the input is a
  named, list, names are preserved in the returned list.
}
\description{
Trimming of waveband boundaries can be needed when the spectral data do not
cover the whole waveband, or wavebands may have to be removed altogether.
}
\details{
This function will accept both individual wavebands or list of
  wavebands. When the input is a list, wavebands outisde the range of the
  range range will be removed from the list, and those partly outside the
  target range either "trimmed" to this edge of removed (if \code{trim =
  TRUE} is passed) or discarded (if \code{trim = FALSE}). If the list of
  wavebands has named members, names are preserved in the returned list.
}
\examples{
VIS <- waveband(c(380, 760)) # nanometres

trim_waveband(VIS, c(400,700))
trim_waveband(VIS, low.limit = 400)
trim_waveband(VIS, high.limit = 700)

}
\seealso{
Other trim functions: 
\code{\link{clip_wl}()},
\code{\link{trim_spct}()},
\code{\link{trim_wl}()}
}
\concept{trim functions}
