% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{valleys}
\alias{valleys}
\alias{valleys.default}
\alias{valleys.numeric}
\alias{valleys.data.frame}
\alias{valleys.generic_spct}
\alias{valleys.source_spct}
\alias{valleys.response_spct}
\alias{valleys.filter_spct}
\alias{valleys.reflector_spct}
\alias{valleys.cps_spct}
\alias{valleys.raw_spct}
\alias{valleys.generic_mspct}
\alias{valleys.source_mspct}
\alias{valleys.response_mspct}
\alias{valleys.filter_mspct}
\alias{valleys.reflector_mspct}
\alias{valleys.cps_mspct}
\alias{valleys.raw_mspct}
\title{Valleys or local minima}
\usage{
valleys(x, span, ignore_threshold, strict, ...)

\method{valleys}{default}(x, span = NA, ignore_threshold = NA, strict = NA, na.rm = FALSE, ...)

\method{valleys}{default}(x, span = NA, ignore_threshold = NA, strict = NA, na.rm = FALSE, ...)

\method{valleys}{numeric}(x, span = 5, ignore_threshold, strict = TRUE, na.rm = FALSE, ...)

\method{valleys}{data.frame}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  x.var.name = NULL,
  y.var.name = NULL,
  var.name = y.var.name,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{generic_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{source_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{response_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{filter_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{reflector_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{cps_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{raw_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{generic_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{source_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{response_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{filter_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{reflector_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{cps_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{raw_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 3, meaning that a peak is bigger than both of
its neighbors. Default: 3.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the
relative size compared to tallest peak threshold below which valleys will be
ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{...}{ignored}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}

\item{var.name, x.var.name, y.var.name}{character Name of column where to look
for valleys.}

\item{refine.wl}{logical Flag indicating if valley location should be refined by
fitting a function.}

\item{method}{character String with the name of a method. Currently only
spline interpolation is implemented.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to local minima.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function usable on numeric vectors.

\item \code{default}: Default returning always NA.

\item \code{numeric}: Default function usable on numeric vectors.

\item \code{data.frame}: Method for "data.frame" objects.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{source_spct}: Method for "source_spct" objects.

\item \code{response_spct}: Method for "response_spct" objects.

\item \code{filter_spct}: Method for "filter_spct" objects.

\item \code{reflector_spct}: Method for "reflector_spct".

\item \code{cps_spct}: Method for "cps_spct" objects.

\item \code{raw_spct}: Method for "raw_spct" objects.

\item \code{generic_mspct}: Method for "generic_mspct" objects.

\item \code{source_mspct}: Method for "source_mspct" objects.

\item \code{response_mspct}: Method for "cps_mspct" objects.

\item \code{filter_mspct}: Method for "filter_mspct" objects.

\item \code{reflector_mspct}: Method for "reflector_mspct" objects.

\item \code{cps_mspct}: Method for "cps_mspct" objects.

\item \code{raw_mspct}: Method for "raw_mspct" objects.
}}

\examples{
valleys(sun.spct, span = 50)

valleys(sun.spct)

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{spikes}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
