% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.smooth.spct.r
\name{smooth_spct}
\alias{smooth_spct}
\alias{smooth_spct.default}
\alias{smooth_spct.source_spct}
\alias{smooth_spct.filter_spct}
\alias{smooth_spct.reflector_spct}
\alias{smooth_spct.solute_spct}
\alias{smooth_spct.response_spct}
\alias{smooth_spct.generic_mspct}
\title{Smooth a spectrum}
\usage{
smooth_spct(x, method, strength, wl.range, ...)

\method{smooth_spct}{default}(x, method, strength, wl.range, ...)

\method{smooth_spct}{source_spct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)

\method{smooth_spct}{filter_spct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)

\method{smooth_spct}{reflector_spct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)

\method{smooth_spct}{solute_spct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)

\method{smooth_spct}{response_spct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)

\method{smooth_spct}{generic_mspct}(
  x,
  method = "custom",
  strength = 1,
  wl.range = NULL,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{an R object.}

\item{method}{a character string "custom", "lowess", "supsmu" or "skip"..}

\item{strength}{numeric value to adjust the degree of smoothing. Ignored if
method-specific parameters are passed through \code{...}.}

\item{wl.range}{any R object on which applying the method \code{range()}
yields a vector of two numeric values, describing a range of wavelengths
(nm) within which spectral data is to be smoothed. \code{NA} is interpreted
as the min or max value of \code{x[[w.length]]}.}

\item{...}{other parameters passed to the underlying smoothing functions.}

\item{na.rm}{logical A flag indicating whether NA values should be stripped
before the computation proceeds.}
}
\value{
A copy of \code{x} with spectral data values replaced by smoothed
  ones.
}
\description{
These functions implement one original methods and acts as a wrapper for
other common R smoothing functions. The advantage of using this function for
smoothing spectral objects is that it simplifies the user interface and sets,
when needed, defaults suitable for spectral data.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Smooth a source spectrum

\item \code{filter_spct}: Smooth a filter spectrum

\item \code{reflector_spct}: Smooth a reflector spectrum

\item \code{solute_spct}: Smooth a solute attenuation spectrum

\item \code{response_spct}: Smooth a response spectrum

\item \code{generic_mspct}: 
}}

\note{
Method "custom" is our home-brewed method which applies strong
  smoothing to low signal regions of the spectral data, and weaker or no
  smoothing to the high signal areas. Values very close to zero are set to
  zero with a limit which depends on the local variation. This method is an
  ad-hock method suitable for smoothing spectral data obtained with
  spectrometers. In the cased of methods "lowess" and "supsmu" the current
  function behaves like a wrapper of the functions of the same names from
  base R. Method "skip" returns \code{x} unchanged.
}
\examples{

my.spct <- clip_wl(sun.spct, c(400, 500))
smooth_spct(my.spct)
smooth_spct(my.spct, method = "custom", strength = 1)
smooth_spct(my.spct, method = "custom", strength = 4)
smooth_spct(my.spct, method = "supsmu", strength = 4)

}
