% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.source.output.R
\name{calc_source_output}
\alias{calc_source_output}
\title{Light-source spectral output}
\usage{
calc_source_output(w.length.out, w.length.in, s.irrad.in, unit.in = "energy",
  scaled = NULL, fill = NA)
}
\arguments{
\item{w.length.out}{numeric vector of wavelengths (nm) for output}

\item{w.length.in}{numeric vector of wavelengths (nm) for input}

\item{s.irrad.in}{numeric vector of spectral transmittance value (fractions
or percent)}

\item{unit.in}{a character string "energy" or "photon"}

\item{scaled}{NULL, "peak", "area"; div ignored if !is.null(scaled)}

\item{fill}{if NA, no extrapolation is done, and NA is returned for
wavelengths outside the range of the input. If NULL then the tails are
deleted. If 0 then the tails are set to zero.}
}
\value{
a source_spct with three numeric vectors with wavelength values
  (w.length), scaled and interpolated spectral energy irradiance (s.e.irrad),
  scaled and interpolated spectral photon irradiance values (s.q.irrad).
}
\description{
Calculate interpolated values by interpolation from
user-supplied spectral emission data or by name for light source data
included in the packages photobiologySun, photobiologyLamps, or
photobiologyLEDs, scaling the values.
}
\note{
This is a convenience function that adds no new functionality but makes
  it a little easier to plot lamp spectral emission data consistently. It
  automates interpolation, extrapolation/trimming and scaling.
}
\examples{
with(sun.data, calc_source_output(290:1100, w.length.in=w.length, s.irrad.in=s.e.irrad))

}
