% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2quantum.multipliers.r
\name{e2quantum_multipliers}
\alias{e2quantum_multipliers}
\title{Calculate energy to quantum multipliers}
\usage{
e2quantum_multipliers(w.length, molar = FALSE)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{molar}{logical Flag indicating whether output should be in moles or
numbers}
}
\value{
A numeric vector of multipliers
}
\description{
Gives multipliers as a function of wavelength, for converting from energy to
photon (quantum) units (number of photons as default, or moles of photons).
}
\examples{
with(sun.data, e2quantum_multipliers(w.length))
with(sun.data, e2quantum_multipliers(w.length, molar = TRUE))

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2Afr}}, \code{\link{T2A}},
  \code{\link{T2T}}, \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
