% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\docType{data}
\name{ex22}
\alias{ex22}
\title{Example 22--Modeling Gas Solubilities: CO2 at High Pressures}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
PHREEQC calculates the fugacity coefficient with the
Peng-Robinson equation of state (Peng and Robinson, 1976) from the critical
pressure and temperature, and the acentric factor of the gas in a gas
mixture to obtain the limiting volume and the attraction factor in the Van
der Waals equation. The fugacity coefficient is close to 1 when the total
pressure of the gas phase is less than about 10 atm, and it can be neglected
in the solubility calculation. At higher pressures, the effect can be
substantial. At low pressures, the concentration of CO2 increases
near-linearly with pressure. At 25 degrees C and pressures higher than 62
atm, the concentration increases more gradually because the fugacity
coefficient drops rapidly. The example can be run using the
\code{\link{phrRunString}} routine.
}
\examples{

phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex22)
phrGetOutputStrings()

}
\references{
\url{http://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: \code{\link{ex10}}, \code{\link{ex11}},
  \code{\link{ex12}}, \code{\link{ex13a}},
  \code{\link{ex14}}, \code{\link{ex15}},
  \code{\link{ex16}}, \code{\link{ex17}},
  \code{\link{ex18}}, \code{\link{ex19}},
  \code{\link{ex1}}, \code{\link{ex20a}},
  \code{\link{ex21}}, \code{\link{ex2}}, \code{\link{ex3}},
  \code{\link{ex4}}, \code{\link{ex5}}, \code{\link{ex6}},
  \code{\link{ex7}}, \code{\link{ex8}}, \code{\link{ex9}}
}
\keyword{dataset}

