% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylepic.R
\name{create_tree_layout}
\alias{create_tree_layout}
\title{Create a graph layout for plotting}
\usage{
create_tree_layout(tree, tip_data = NULL)
}
\arguments{
\item{tree}{A tree-like graph or a \code{phylepic} object.}

\item{tip_data}{A data frame with tip metadata. There must be a column called
\code{.phylepic.name} with values that correspond to the names of leaf nodes in
the tree. If \code{NULL}, no tip data is joined onto the tree.}
}
\value{
A "layout_ggraph" object suitable for plotting with \link[ggplot2:ggplot]{ggplot2::ggplot}`.
}
\description{
This lays out a graph using \code{ggraph::create_layout()} with the \code{"dendrogram"}
layout, takes edge lengths from the tree, and flips the layout coordinates.
The plotting functions associated with \code{\link[=phylepic]{phylepic()}} expect the graph to
be laid out using these settings.
}
