% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sackin.R
\name{sackin.phylo}
\alias{sackin.phylo}
\title{Sackin index}
\usage{
sackin.phylo(tree, normalise = FALSE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result, default is \code{FALSE}.}
}
\value{
The Sackin index of the tree.
}
\description{
Finds the Sackin index for a tree. 
Note that the package \code{apTreeshape} has a function \code{sackin} to compute the Sackin index with additional options to normalise it based on the model;
we include this simple function here for convenience within this package, and for use on objects of class \code{phylo} and \code{phylo4}.
}
\examples{
## Sackin index of a random tree with 10 tips:
sackin.phylo(rtree(10))

## normalised Sackin index:
sackin.phylo(rtree(10), normalise=TRUE)


}
\author{
Michael Boyd \email{mboyd855@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

