% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stairs.R
\name{stairs}
\alias{stairs}
\title{Stairs}
\usage{
stairs(tree)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}
}
\value{
Two numbers corresponding to the two staircase-ness measures for a tree. These are two related measures:
\itemize{ 
\item 1: the proportion of subtrees that are imbalanced (i.e. subtrees where the left child has more tip descendants than the right child, or vice versa)
\item 2: the average of all the min(l,r)/max(l,r) values of each subtree, where l and r are the number of tips in the left and right children of a subtree.
}
}
\description{
Calculates the staircase-ness measure defined in Norstrom et al., Evolutionary Bioinformatics online, 8:261 (2012) \doi{10.4137/EBO.S9738}.
}
\examples{
## Find the staircase-ness measures in a random tree with 20 tips:
stairs(rtree(20))
 

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
