% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_slice.R
\name{timeslice}
\alias{timeslice}
\title{Slice phylogenetic tree at various time depths}
\usage{
timeslice(phy, n = 0.2, collapse = FALSE, ...)
}
\arguments{
\item{phy}{A dated phylogenetic tree as an object of class \dQuote{phylo}.}

\item{n}{Time depth to slice the phylogenetic tree (often in millions of
years for dated trees).}

\item{collapse}{Logical, collapse internal edges with zero edge length.}

\item{\dots}{arguments passed among methods.}
}
\value{
{A tree with the phylogenetic structure removed at the specified time depth}
}
\description{
This function slices a dated phylogenetic tree at successive time depths back
in time by collapsing younger phylogenetic branches into older ones to infer
the origins of species assemblages.
}
\examples{
library(ape)

set.seed(1)
tree <- rcoal(50)
x <- timeslice(tree, .5)

old.par <- par(no.readonly = TRUE)
par(mfrow = c(1, 2))
plot(tree)
axisPhylo()
plot(x)
axisPhylo()
par(old.par)
}
\references{
Daru, B.H., van der Bank, M. & Davies, T.J. (2018) Unravelling the
evolutionary origins of biogeographic assemblages.
\emph{Diversity and Distributions} \strong{24}: 313–324.
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{phyloregion}
