% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_phyloregions.R
\name{plot.phyloregion}
\alias{plot.phyloregion}
\alias{plot_NMDS}
\alias{text_NMDS}
\title{Visualize biogeographic patterns}
\usage{
\method{plot}{phyloregion}(x, shp = NULL, palette = "NMDS", ...)

plot_NMDS(x, ...)

text_NMDS(x, ...)
}
\arguments{
\item{x}{an object of class phyloregion from \code{phyloregion}}

\item{shp}{a polygon shapefile of grid cells.}

\item{palette}{name of the palette to generate colors from. The default,
\dQuote{NMDS}, allows display of phyloregions in multidimensional
scaling color space matching the color vision of the human visual
system. The name is matched to the list of available color palettes from
the \code{hcl.colors} function in the \code{grDevices} package.}

\item{\dots}{arguments passed among methods.}
}
\value{
No return value, called for plotting.
}
\description{
Visualize biogeographic patterns
}
\examples{
data(africa)
tree <- africa$phylo
x <- africa$comm

subphy <- match_phylo_comm(tree, x)$phy
submat <- match_phylo_comm(tree, x)$com

pbc <- phylobeta(submat, subphy)
y <- phyloregion(pbc[[1]], shp=africa$polys)

plot_NMDS(y, cex=6)
text_NMDS(y, cex=2)
plot(y, cex=1, palette="NMDS")
plot(y, cex=1)
}
