% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphtest-functions.R
\name{graph_perm_test}
\alias{graph_perm_test}
\title{Performs graph-based permutation tests}
\usage{
graph_perm_test(physeq, sampletype, grouping = 1:nsamples(physeq),
  distance = "jaccard", type = c("mst", "knn", "threshold.value",
  "threshold.nedges"), max.dist = 0.4, knn = 1, nedges = nsamples(physeq),
  keep.isolates = TRUE, nperm = 499)
}
\arguments{
\item{physeq}{A phyloseq object.}

\item{sampletype}{A string giving the column name of the sample to
be tested. This should be a factor with two or more levels.}

\item{grouping}{Either a string with the name of a sample data
column or a factor of length equal to the number of samples in
physeq. These are the groups of samples whose labels should be
permuted and are used for repeated measures designs. Default is no
grouping (each group is of size 1).}

\item{distance}{A distance, see \code{\link[phyloseq]{distance}} for a
list of the possible methods.}

\item{type}{One of "mst", "knn", "threshold". If "mst", forms the
minimum spanning tree of the sample points. If "knn", forms a
directed graph with links from each node to its k nearest
neighbors. If "threshold", forms a graph with edges between every
pair of samples within a certain distance.}

\item{max.dist}{For type "threshold", the maximum distance between
two samples such that we put an edge between them.}

\item{knn}{For type "knn", the number of nearest neighbors.}

\item{nedges}{If using "threshold.nedges", the number of edges to use.}

\item{keep.isolates}{In the returned network, keep the unconnected
points?}

\item{nperm}{The number of permutations to perform.}
}
\value{
A list with the observed number of pure edges, the vector
containing the number of pure edges in each permutation, the
permutation p-value, the graph used for testing, and a vector with
the sample types used for the test.
}
\description{
Performs graph-based tests for one-way designs.
}
\examples{
library(phyloseq)
data(enterotype)
gt = graph_perm_test(enterotype, sampletype = "SeqTech", type = "mst")
gt
}
