% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphClust.R
\name{graphClust}
\alias{graphClust}
\title{Phylogenetically constrained  clustering}
\usage{
graphClust(p4d, trait = names(tdata(p4d)), lim.phylo = 0.2,
  lim.trait = 0.2, select.method = "ellipse", dist.phylo = "patristic",
  dist.trait = "euclidean", scale.lim = TRUE)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{trait}{the traits in the \code{phylo4d} object to use for clustering.
Can be a character vector giving the name of the traits or numbers giving the column index
in the table of the data slot of the \code{phylo4d} object.}

\item{lim.phylo}{the maximum phylogenetic distance for edges selection.}

\item{lim.trait}{the maximum trait-based distance for edges selection.}

\item{select.method}{a character string specifying the method used to select edges.
This must be one of "\code{line}", "\code{rectangle}" or "\code{ellipse}".}

\item{dist.phylo}{a matrix of phylogenetic distances or a character string specifying a method to compute it.
See Details.}

\item{dist.trait}{a character string specifying the method used to compute traits distances.
See Details.}

\item{scale.lim}{logical (default \code{TRUE}) indicating if \code{lim.phylo} and \code{lim.trait} are scaled
(divided by their max value).}
}
\value{
An object of class \code{graphclust}.
}
\description{
This function extracts clusters of species based on traits values and phylogenetic proximities.
}
\details{
If "\code{dist.phylo}" is a character string,
the phylogenetic distance matrix is computed internally
using the function \code{\link[adephylo]{distTips}} from the package \pkg{adephylo}.
All the methods supported by \code{\link[adephylo]{distTips}} are available:
"\code{patristic}","\code{nNodes}","\code{Abouheif}" and "\code{sumDD}".
See \code{\link[adephylo]{distTips}} for details about the methods.

If "\code{dist.trait}" is a character string,
the traits distance matrix is computed with the \code{\link[stats]{dist}} function.
All the methods supported by \code{\link[stats]{dist}} are available:
"\code{euclidean}","\code{maximum}", "\code{manhattan}",
"\code{canberra}", "\code{binary}" and "\code{minkowski}".
See \code{\link[stats]{dist}} for details about the methods.
}
\examples{
data(navic)
gC <- graphClust(navic, lim.phylo = 1, lim.trait = 2, scale.lim = FALSE)
gC
plot.graphclust(gC, which = "selection", ask = FALSE)
plot.graphclust(gC, which = "graph", ask = FALSE)
plot.graphclust(gC, which = "tree", ask = FALSE)

}
