% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlogram.R
\name{plot.phylocorrelogram}
\alias{plot.phylocorrelogram}
\title{Plot a phylogenetic correlogram}
\usage{
\method{plot}{phylocorrelogram}(x, show.ci = TRUE, show.h0 = TRUE,
  show.test = TRUE, xlab = "Phylogenetic distance", ylab = "Correlation",
  main = "Phylogenetic correlogram", ...)
}
\arguments{
\item{x}{a \code{phylocorrelogram} object.}

\item{show.ci}{a logical indicating whether to plot the confidence interval envelop (default \code{TRUE}).}

\item{show.h0}{a logical indicating whether to plot the the line showing the expected
value of Moran's I under the null hypothesis of no phylogenetic autocorrelation (default \code{TRUE}).}

\item{show.test}{a logical indicating whether to plot indicator of significance (default \code{TRUE}).}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{main}{a main title for the plot}

\item{...}{other graphical parameters passed to the \code{plot} function.}
}
\description{
This function plots phylogenetic correlograms produced by \code{\link{phyloCorrelogram}}
}
\examples{
\dontrun{
data(navic)
pc <- phyloCorrelogram(navic)
plot(pc)
}
}
