% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ventilation.R
\name{deadspace_total}
\alias{deadspace_total}
\alias{deadspace_anatomic}
\alias{deadspace_anatomic_adult}
\alias{deadspace_anatomic_child}
\alias{deadspace_intrathoracic_ml}
\title{Estimate ventilation dead-space}
\usage{
deadspace_total(ideal_weight_kg, age_y = NULL, elbow_ml = 10,
  humidifier_ml = 7, ett_diameter_mm = NULL)

deadspace_anatomic(ideal_weight_kg, age_y = NULL)

deadspace_anatomic_adult(ideal_weight_kg = NULL)

deadspace_anatomic_child(ideal_weight_kg, age_y = NULL)

deadspace_intrathoracic_ml(ideal_weight_kg)
}
\arguments{
\item{ideal_weight_kg}{Ideal weight in kilograms. May be calculated using
\code{\link{ideal_weight_adult}} or \code{\link{ideal_weight_child}}}

\item{age_y}{Age in years, optional for estimating ETT and HME sizes
automatically}

\item{elbow_ml}{Numeric volume of elbow of breathing circuit in ml}

\item{humidifier_ml}{Numeric volume of humidifier of breathing circuit in ml}

\item{ett_diameter_mm}{Numeric internal diameter of endotracheal tube.
Default is \code{NULL} which would estimate this from the age of patient}
}
\value{
estimate of anatomic dead-space in ml
}
\description{
Estimate ventilation dead-space
}
\details{
'Mean intrathoracic anatomic dead space was 1.03 ml/kg and was not
  related to age.' Numa, 1985
}
\section{Functions}{
\itemize{
\item \code{deadspace_anatomic}: Estimate anatomic dead-space

\item \code{deadspace_anatomic_adult}: Estimate anatomic dead-space in an adult

\item \code{deadspace_anatomic_child}: Estimate anatomic dead-space in an infant or
child

\item \code{deadspace_intrathoracic_ml}: intrathoracic component of dead-space is age
independent
}}

\examples{
  height <- seq(1, 2, 0.05)
  male <- rep(FALSE, length(height))
  iw <- ideal_weight_adult(height_m = height, male = male)
  plot(iw, deadspace_anatomic_adult(ideal_weight_kg = height))

  # discontinuity at age 6 is driven by ideal weight more than the
  # lograithmic calculation
  iw <- c(seq(12, 18, 0.2), seq(18.5, 24, 0.5))
  youngest = 3
  oldest = 9
  ages <- seq(youngest, oldest, (oldest - youngest) / (length(iw) - 1))
  plot(iw, deadspace_anatomic_child(ideal_weight_kg = iw, age_y = ages),
       type = "l")

}
\references{
\url{http://www.atsjournals.org/doi/abs/10.1164/arrd.1971.104.2.215}
  \url{http://rc.rcjournal.com/content/53/7/885.short}
  \url{https://www.ncbi.nlm.nih.gov/pubmed/8727530}
}
