% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rr.R
\name{check.rr}
\alias{check.rr}
\title{Check Relative Risk}
\usage{
check.rr(X, thetahat, rr, tol = 1e-08)
}
\arguments{
\item{X}{Random sample (data.frame) which includes exposure and
covariates. or sample mean if approximate method is selected.}

\item{thetahat}{Estimator (vector or matrix) of \code{theta} for the 
Relative Risk function.}

\item{rr}{Function for Relative Risk which uses parameter 
\code{theta}. The order of the parameters should be \code{rr(X, theta)}.}

\item{tol}{Tolerance for concluding numeric equality.}
}
\value{
boolean Indicating \code{TRUE} if relative risk \code{rr} is as desired.
}
\description{
Function for checking that Relative Risk \code{rr} equals
  \code{1} when evaluated in \code{0}.
}
\examples{
X  <- data.frame(rnorm(100))
rr <- function(X, theta){exp(X*theta)}
check.rr(X, 1, rr)

}
\seealso{
\code{\link{check.confidence}}, \code{\link{check.thetas}}, 
  \code{\link{check.cft}}, \code{\link{check.xvar}}, 
  \code{\link{check.exposure}}, \code{\link{check.integrals}}
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
