% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_download.R
\name{pb_download}
\alias{pb_download}
\title{Download data from an existing release}
\usage{
pb_download(
  file = NULL,
  dest = ".",
  repo = guess_repo(),
  tag = "latest",
  overwrite = TRUE,
  ignore = "manifest.json",
  use_timestamps = TRUE,
  show_progress = TRUE,
  .token = get_token()
)
}
\arguments{
\item{file}{name or vector of names of files to be downloaded. If \code{NULL},
all assets attached to the release will be downloaded.}

\item{dest}{name of vector of names of where file should be downloaded.
Can be a directory or a list of filenames the same length as \code{file}
vector. Any directories in the path provided must already exist.}

\item{repo}{Repository name in format "owner/repo". Will guess
the current repo if not specified.}

\item{tag}{tag for the GitHub release to which this data is attached}

\item{overwrite}{Should any local files of the same name be overwritten?
default \code{TRUE}.}

\item{ignore}{a list of files to ignore (if downloading "all" because
\code{file=NULL}).}

\item{use_timestamps}{If \code{TRUE}, then files will only be downloaded
if timestamp on GitHub is newer than the local timestamp (if
\code{overwrite=TRUE}).  Defaults to \code{TRUE}.}

\item{show_progress}{logical, should we show progress bar for download?
Defaults to \code{TRUE}.}

\item{.token}{GitHub authentication token. Typically set from an
environmental variable, e.g. in a \code{.Renviron} file or with
\code{Sys.setenv(GITHUB_TOKEN = "xxxxx")}, which helps prevent
accidental disclosure of a secret token when sharing scripts.}
}
\description{
Download data from an existing release
}
\examples{
\dontrun{
 ## Download a specific file.
 ## (dest can be omitted when run inside and R project)
 piggyback::pb_download("data/iris.tsv.gz",
                        repo = "cboettig/piggyback-tests",
                        dest = tempdir())
}
\dontrun{
 ## Download all files
 piggyback::pb_download(repo = "cboettig/piggyback-tests",
                        dest = tempdir())

}
}
