% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{allele_diff_strings}
\alias{allele_diff_strings}
\title{Calculate differences between characters in columns of germs and return them as a string vector.}
\usage{
allele_diff_strings(germs, X = 0L, non_mismatch_chars_nullable = NULL)
}
\arguments{
\item{germs}{A vector of strings representing germ sequences.}

\item{X}{The threshold index from which to return differences as strings.}

\item{non_mismatch_chars_nullable}{A set of characters that are ignored when comparing sequences (default: 'N', '.', '-').}
}
\value{
A vector of strings containing differences between characters in columns.
}
\description{
Calculate differences between characters in columns of germs and return them as a string vector.
}
\examples{
germs = c("ATCG", "ATCC") 
X = 3 
result = allele_diff_strings(germs, X) 
# "A2T", "T3C", "C2G"
}
