% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigfig.R, R/styles.R
\name{style_num}
\alias{style_num}
\alias{style_subtle}
\alias{style_bold}
\alias{style_na}
\alias{style_neg}
\title{Styling helpers}
\usage{
style_num(x, negative, significant = rep_along(x, TRUE))

style_subtle(x)

style_bold(x)

style_na(x)

style_neg(x)
}
\arguments{
\item{x}{The character vector to style.}

\item{negative, significant}{Logical vector the same length as \code{x} that
indicate if the values are negative and significant, respectively}
}
\description{
Functions that allow implementers of formatters for custom data types to
maintain a consistent style with the default data types.
}
\details{
\code{style_subtle()} is affected by the \code{pillar.subtle} option.

\code{style_bold()} is affected by the \code{pillar.bold} option.

\code{style_neg()} is affected by the \code{pillar.neg} option.
}
\examples{
style_num(
  c("123", "456"),
  negative = c(TRUE, FALSE)
)
style_num(
  c("123", "456"),
  negative = c(TRUE, FALSE),
  significant = c(FALSE, FALSE)
)
style_subtle("text")
style_bold("Petal.Width")
style_na("NA")
style_neg("123")
}
\seealso{
\link{pillar-package} for a list of options
}
