% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nobs.R
\docType{methods}
\name{nobs,pim.environment-method}
\alias{nobs,pim.environment-method}
\alias{nobs,pim.poset-method}
\alias{nobs,matrix-method}
\alias{nobs,data.frame-method}
\title{Extract the number of observations}
\usage{
\S4method{nobs}{pim.environment}(object)

\S4method{nobs}{pim.poset}(object)

\S4method{nobs}{matrix}(object)

\S4method{nobs}{data.frame}(object)
}
\arguments{
\item{object}{an object of the class \code{\link{pim.environment}} or \code{\link{pim.poset}}}

\item{...}{arguments passed to other methods.}
}
\value{
In case the function is called on a \code{pim.environment}
or a \code{pim.poset} object, 
an integer with the number of (foreseen) observations. If the
pim.environment is empty, it returns \code{0}. 

In all other cases, it returns the output of either \code{\link{nrow}} (for
matrices and data.frames)
or \code{\link{length}}.
}
\description{
This function extracts the number of observations in an object
of class \code{\link{pim.environment}}, or the number of observations
for which a \code{\link{pim.poset}} is constructed. If applied to
a matrix or data.frame, it returns the number of rows. 
For any other object it 
does the same as \code{\link{length}}.
}
\details{
This package imports the generic \code{\link[stats]{nobs}} from the package
\code{stats4}.
}
