\name{writeperl}
\alias{writeperl}
\title{ Writes the perl file(s) for pinktoe}
\description{
	A perl file needs to be written that works out whether a tick box has been checked and then calls either code to
	deal with a leaf or an HTML file for another decision to be made. 
}
\usage{
writeperl(childleftrow, childrightrow, treeobj, perlname, edmlabel, htmldir, edmix, stateprintfn, requirelib)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{childleftrow}{ The "left" hand row number possibility stemming from this node.}
  \item{childrightrow}{ The "right" hand row number possibility stemming from this node.}
  \item{treeobj}{ The \code{rpart} or \code{tree} object that this whole process is using}
  \item{perlname}{ The name of the perl file to construct (returned earlier from \code{\link{writehtml}}}
  \item{edmlabel}{ The variable name (from the \code{var} field of the original tree) for this HTML file/question. }
  \item{htmldir}{ A character string containing the directory where the HTML
                files generated by pinktoe (with the extension \code{.htm})
                will be stored.  (This should be a pathname understood and
                able to be found by perl).}

  \item{edmix}{ A vector of the node numbers (row names of the \$frame component of the tree)}
  \item{stateprintfn}{A user-supplied function that decides what to do when
        supplied with the \code{yval} reached at the leaf of a tree. Some
        text can be output, or maybe a perl function call.  }

  \item{requirelib}{A library of perl functions that can be called by, e.g.
        \code{stateprintfn}. The library that this refers to
        should reside in the \code{cgibin} directory. If no function calls
        are planned then it doesn't matter what argument is supplied.}

}
\details{
	The HTML file that preceeds the construction of the currently described perl file 
	describes a decision with two possible courses of action. These are coded in the \code{childleftrow}
	and \code{childrightrow} arguments. Perl code is written to work out whether the checkbox in the
	HTML code was ticked or note and then execute the relevant next HTML file or leaf code.
}
\value{
  No value returned.
}
\references{ 
\url{http://www.stats.bris.ac.uk/~magpn/Research/Pinktoe/Welcome.html}
}
\author{Guy P Nason }
\note{ Not intended for general user use}

\seealso{ \code{\link{pinktoe}}}
\examples{
#
#Not intended for general user use
#
}
\keyword{ internal }% at least one, from doc/KEYWORDS
