% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b31gafr.R
\name{b31gafr}
\alias{b31gafr}
\title{ASME B31G. A-factor}
\usage{
b31gafr(d, wth, l)
}
\arguments{
\item{d}{nominal outside diameter of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{wth}{nominal wall thickness of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{l}{measured maximum longitudinal length of the corroded area, [\emph{inch}].
Type: \code{\link{assert_double}}.}
}
\value{
Intermediate factor related to the geometry of the corroded area, [].
 Type: \code{\link{assert_double}}.
}
\description{
Calculate intermediate factor related to the geometry of the corroded zone.
}
\examples{
 b31gafr(30, .438, 7.5)
 # [1] 1.847  # A-factor is less than 5, so the corrosion is not critical

}
\references{
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31g.1991.pdf}{ASME B31G-1991}.
 Manual for determining the remaining strength of corroded pipelines. A
 supplement to \emph{ASTME B31} code for pressure piping.
}
\seealso{
Other ASME B31G functions: 
\code{\link{b31crvl}()},
\code{\link{b31gacd}()},
\code{\link{b31gacl}()},
\code{\link{b31gdep}()},
\code{\link{b31gmodpf}()},
\code{\link{b31gops}()},
\code{\link{b31gpf}()},
\code{\link{b31gsap}()}
}
\concept{ASME B31G functions}
