% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_plots.R
\name{pir_plots}
\alias{pir_plots}
\title{Plot the output of \link{pir_runs}.}
\usage{
pir_plots(pir_outs, check_input = TRUE, verbose = FALSE)
}
\arguments{
\item{pir_outs}{the output of \link{pir_runs}}

\item{check_input}{boolean to indicate if the input is checked.
If set to \link{TRUE}, input is checked, resulting in a proper
error message. Else, input is left unchecked, possibly resulting
in unhelpful error messages.}

\item{verbose}{if TRUE, show more output}
}
\value{
a \code{ggplot2} plot
}
\description{
Plot the output of \link{pir_runs}.
}
\examples{

# Create fake pir_run output
pir_outs <- list()
pir_outs[[1]] <- create_test_pir_run_output(
  add_twin = TRUE,
  add_best = TRUE
)
pir_outs[[2]] <- pir_outs[[1]]

# Plot the (fake) output
pir_plots(pir_outs)
}
\author{
Richèl J.C. Bilderbeek
}
