% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_standard_mutation_rate.R
\name{create_standard_mutation_rate}
\alias{create_standard_mutation_rate}
\title{Create the parameters for the mutation rate}
\usage{
create_standard_mutation_rate(phylogeny)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}
}
\value{
the mutation rate
}
\description{
Create the parameters for the mutation rate
}
\examples{

# Phylogeny with a crown age of 3.0
phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
# Expected mutation rate is one divided by the crown age
create_standard_mutation_rate(phylogeny) # 0.333

# Phylogeny with a crown age of 4.0
phylogeny <- ape::read.tree(text = "((A:2, B:2):2, C:4);")
# Expected mutation rate is one divided by the crown age
create_standard_mutation_rate(phylogeny) # 0.25

}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
