% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_true_alignment.R
\name{create_true_alignment}
\alias{create_true_alignment}
\title{Create the true alignment from the true/given phylogeny.}
\usage{
create_true_alignment(true_phylogeny, alignment_params)
}
\arguments{
\item{true_phylogeny}{the true phylogeny; the actual evolutionary
history of the species, of class \link[ape]{phylo}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}
}
\value{
an alignment of type \code{DNAbin}
}
\description{
We call this the true alignment, as it could thruthfully be found
in nature, when assuming the true phylogeny is the true
evolutionary history.
}
\examples{
# Create the ancestor's DNA sequence
n_base_pairs <- 4
root_sequence <- create_blocked_dna(length = n_base_pairs)

# How to simulate the alignment
alignment_params <- create_alignment_params(
  root_sequence = root_sequence
)

# Create a phylogeny to simulate the DNA sequences on
n_taxa <- 5
phylogeny <- ape::rcoal(n_taxa)

# Simulate the alignment
alignment <- create_true_alignment(
   true_phylogeny = phylogeny,
   alignment_params = alignment_params
 )
check_alignment(alignment)
}
\seealso{
Use \link{create_tral_file} to save the created alignment
  directly to a file
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
