% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_to_pics.R
\name{pir_to_pics}
\alias{pir_to_pics}
\title{Create all pictures created by the \link{pirouette} pipeline}
\usage{
pir_to_pics(
  phylogeny,
  pir_params,
  consensus = rev(sort(phylogeny$tip.label)),
  folder = tempdir()
)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}

\item{consensus}{the order of which the taxon labels are plotted}

\item{folder}{folder where the files are stored in.
By default, this is a temporary folder}
}
\value{
the names of all files created
}
\description{
These are the files created:
\itemize{
  \item \code{true_tree.png} the true/given phylogeny
  \item \code{true_alignment.png} the alignment simulated from the
    true/given phylogeny
  \item \code{twin_tree.png} the twin tree [1]
  \item \code{twin_alignment.png} the alignment simulated from the
    twin phylogeny
  \item \code{true_posterior_gen.png}
    the phylogenies of the Bayesian posterior,
    using a generative inference model,
    based on the alignment based on the true tree
  \item \code{twin_posterior_gen.png}
    the phylogenies of the Bayesian posterior,
    using a generative inference model,
    based on the alignment based on the twin tree
  \item \code{true_error_histogram_gen.png}
    the errors between the Bayesian posterior
    and true/given tree,
    using a generative inference model,
    plotted as a histogram
  \item \code{twin_error_histogram_gen.png}
    the errors between the Bayesian posterior
    and twin tree,
    using a generative inference model,
    plotted as a histogram
  \item \code{true_error_violin_gen.png}
    the errors between the Bayesian posterior
    and true/given tree,
    using a generative inference model,
    plotted as a violin plot
  \item \code{twin_error_violin_gen.png}
    the errors between the Bayesian posterior
    and twin tree,
    using a generative inference model,
    plotted as a violin plot
  \item \code{true_posterior_best.png}
    the phylogenies of the Bayesian posterior,
    using the best candidate inference model,
    based on the alignment based on the true tree
  \item \code{twin_posterior_best.png}
    the phylogenies of the Bayesian posterior,
    using the best candidate inference model,
    based on the alignment based on the twin tree
  \item \code{true_error_histogram_best.png}
    the errors between the Bayesian posterior
    and true/given tree,
    using the best candidate inference model,
    plotted as a histogram
  \item \code{twin_error_histogram_best.png}
    the errors between the Bayesian posterior
    and twin tree,
    using the best candidate inference model,
    plotted as a histogram
  \item \code{true_error_violin_best.png}
    the errors between the Bayesian posterior
    and true/given tree,
    using the best candidate inference model,
    plotted as a violin plot
  \item \code{twin_error_violin_best.png}
    the errors between the Bayesian posterior
    and twin tree,
    using the best candidate inference model,
    plotted as a violin plot
}
Items marked [1] are created dependent on the setup.
}
\examples{
if (beautier::is_on_ci()) {

  phylogeny <- ape::read.tree(text = "((A:1, B:1):1, C:2);")

  pir_params <- create_test_pir_params(
    twinning_params = create_twinning_params()
  )

  if (rappdirs::app_dir()$os != "win" &&
    beautier::is_on_ci() && beastier::is_beast2_installed()
  ) {

    pir_out <- pir_run(phylogeny = phylogeny, pir_params = pir_params)

    folder <- tempdir()
    expected_filenames <- c(
      file.path(folder, "true_tree.png"),
      file.path(folder, "true_alignment.png"),
      file.path(folder, "twin_tree.png"),
      file.path(folder, "twin_alignment.png"),
      file.path(folder, "true_posterior_gen.png"),
      file.path(folder, "twin_posterior_gen.png"),
      file.path(folder, "true_error_histogram_gen.png"),
      file.path(folder, "twin_error_histogram_gen.png"),
      file.path(folder, "true_error_violin_gen.png"),
      file.path(folder, "twin_error_violin_gen.png")
    )

    # created_filenames are the filenames of the pictures
    created_filenames <- pir_to_pics(
      phylogeny = phylogeny,
      pir_params = pir_params,
      folder = folder
    )

  }
}
}
\author{
Richèl J.C. Bilderbeek
}
