% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotFilter.R
\docType{class}
\name{PivotFilter}
\alias{PivotFilter}
\title{A class that defines a filter condition.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define a single pivot table filter.
}
\description{
The PivotFilter class represents a single filter condition.  The condition
relates to one column and is of the form [ColumnName] IN c(Value1, Value2,
Value3, ...).  Often in a pivot table, each filter specifies only one data
value, as typically each distinct data value exists in a separate row or
column.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}

\item{\code{variableName}}{The name of the column in the data frame that this filter
will apply to.}

\item{\code{safeVariableName}}{The name of the column, surrounded by back-ticks, if
the name is not legal.}

\item{\code{values}}{A single data value or a vector of data values that could/can
be found in the data frame column.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new pivot filter, specifying the field
  values documented above.}

  \item{\code{intersect(filter)}}{Update this PivotFilter by intersecting
  the allowed values in this filter with the allowed values in the specified
  filter.}
  \item{\code{union(filter)}}{Update this PivotFilter by unioning
  the allowed values in this filter with the allowed values in the specified
  filter.}
  \item{\code{replace(filter)}}{Update this PivotFilter by replacing the
  allowed values in this filter with the allowed values from the specified
  filter.}
  \item{\code{getCopy()}}{Get a copy of this PivotFilter.}
  \item{\code{asList()}}{Get a list representation of this PivotFilter.}
  \item{\code{asJSON()}}{Get a list representation of this PivotFilter.}
  \item{\code{asString(includeVariableName=TRUE, seperator=" ")}}{Get a text
  representation of this PivotFilter.}
}
}

\examples{
pt <- PivotTable$new()
# ...
PivotFilter$new(pt, variableName="Country", values="England")
}
