% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixel_category.R
\name{pixel_category}
\alias{pixel_category}
\alias{is.category}
\alias{summary.pixel_category}
\title{Creates a category object}
\usage{
pixel_category(cat_name, cat_colour, ...)

is.category(x)

\method{summary}{pixel_category}(object, ...)
}
\arguments{
\item{cat_name}{a character string containing the name of the category.}

\item{cat_colour}{a character string defining the colour to paint the pixels
with when creating a classified picture.}

\item{\dots}{in \code{pixel_category()} a list of objects of class
\code{"pixel_subcategory"} or \code{"pixel_rule"}; in \code{summary()},
additional parameters (none needed by now).}

\item{x}{the R object being tested}

\item{object}{an object of class \code{"pixel_category"}.}
}
\value{
An object of class \code{"pixel_category"} which is a list with the
  following elements:
  \itemize{
  \item \code{name}: the character string with the name of the pixel
  category.
  \item \code{colour}: a character string describing the
  colour of the pixels of the category in the classified images.
  \item \code{subcats}: a list of \code{"pixel_subcategory"} objects.}
}
\description{
Creates an object of class \code{"pixel_category"}, which contains a list of
objects of class \code{"pixel_subcategory"}.
}
\details{
The function receives a list of objects of class
  \code{"pixel_subcategory"} and creates an object of class
  \code{"pixel_category"} with them. However, subcategories are not always
  needed (see \code{\link{pixel_subcategory}}). In these cases
  \code{"pixel_rule"} objects can be passed to this function, which creates
  an internal subcategory object (named "S0") to contain them. See the
  examples below.

  Note that it is an error to pass a mixture of \code{"pixel_rule"} and
  \code{"pixel_subcategory"} objects.

  \code{colour} can be specified in any form understood by
  \code{grDevices::col2grb}.
}
\examples{
# This set of rules is not consistent, they are only useful as examples
rule01 <- pixel_rule("R01", "g", "b",
                      list(c(0.35, 0.30), c(0.45, 0.10)), ">=")
rule02 <- pixel_rule("R02", "g", "b",
                      list(c(0.35, 0.253), c(0.45, 0.253)), ">=")
rule03 <- pixel_rule("R03", "g", "b",
                      list(c(0.35, 0.29), c(0.49, 0.178)), ">=")
rule04 <- pixel_rule("R04", "g", "b",
                      list(c(0.35, 0.253), c(0.45, 0.253)), "<")

subcat01 <- pixel_subcategory("Subcat01", rule01, rule02)
subcat02 <- pixel_subcategory("Subcat02", rule03, rule04)

cat01 <- pixel_category("Cat01", "#ffae2a", subcat01, subcat02)

# A single category defined by a set of rules, not subcategories
cat02 <- pixel_category("Cat02", "#00ae2a", rule01, rule02, rule03)

}
\seealso{
\code{\link{pixel_rule}}, \code{\link{pixel_subcategory}},
  \code{\link[grDevices]{col2rgb}}
}
