% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgrepo.R
\name{pkg_repo}
\alias{pkg_repo}
\title{Retrieve Package Versions from a Repository}
\usage{
pkg_repo(pkgs = NULL, ver = "current", libpaths = NULL)
}
\arguments{
\item{pkgs}{A vector of package names used to subset the repository list.
Default is NULL, which means all packages in the repository will be returned.}

\item{ver}{The R version of the repository. Pass the R version
as a quoted string. Default is "current",
meaning the current version of the repository. The value "latest"
will return the latest versions on CRAN.}

\item{libpaths}{A vector of paths specifying the locations of the repositories
to query. Default
is NULL, meaning the function will use the default R locations on the machine.
These default paths are identified by the Base R function \code{.libPaths()}.}
}
\value{
An object of class "prepo".  The object will contain a data
frame of R packages with corresponding version numbers.  This table
may then be passed to \code{\link{repo_breakages}} or
\code{\link{repo_stability}}.

If a package is not found in the repo,
a row will still be returned for the package.  However, the version
will appear as NA.
}
\description{
The \code{pkg_repo} function combines information related to a package repository.
The function retrieves all the packages in a repository for a specified version
of R.  Results will list the package name and version.
}
\examples{
# Create vector of packages
pkgs <- c("common", "dplyr", "rvest", "stringr")

# Retrieve latest versions
pkg_repo(pkgs, ver = "latest")
# # A package repo object
# - Repo Version: latest
# - Packages:
#   Package Version
# 1  common   1.1.3
# 2   dplyr   1.1.4
# 3   rvest   1.0.4
# 4 stringr   1.5.1

}
\seealso{
Other prepo: 
\code{\link{print.prepo}()},
\code{\link{print.rbreak}()},
\code{\link{print.rstability}()},
\code{\link{repo_breakages}()},
\code{\link{repo_stability}()}
}
\concept{prepo}
