% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-reference.R
\name{build_reference}
\alias{build_reference}
\alias{build_reference_index}
\title{Build reference section}
\usage{
build_reference(pkg = ".", lazy = TRUE, document = FALSE,
  examples = TRUE, run_dont_run = FALSE, mathjax = TRUE, seed = 1014,
  override = list(), preview = NA)

build_reference_index(pkg = ".")
}
\arguments{
\item{pkg}{Path to package.}

\item{lazy}{If \code{TRUE}, only rebuild pages where the \code{.Rd}
is more recent than the \code{.html}. This makes it much easier to
rapidly protoype. It is set to \code{FALSE} by \code{\link[=build_site]{build_site()}}.}

\item{document}{If \code{TRUE}, will run \code{\link[devtools:document]{devtools::document()}} before
updating the site.}

\item{examples}{Run examples?}

\item{run_dont_run}{Run examples that are surrounded in \\dontrun?}

\item{mathjax}{Use mathjax to render math symbols?}

\item{seed}{Seed used to initialize so that random examples are
reproducible.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}
}
\description{
By default, pkgdown will generate an index that simply lists all
the functions in alphabetical order. To override this, provide a
\code{reference} section in your \code{_pkgdown.yml} as described
below.
}
\section{YAML config}{

To tweak the index page, you need a section called \code{reference}
which provides a list of sections containing, a \code{title}, list of
\code{contents}, and optional \code{description}.

For example, the following code breaks up the functions in pkgdown
into two groups:\preformatted{reference:
- title: Render components
  desc:  Build each component of the site.
  contents:
  - starts_with("build_")
  - init_site
- title: Templates
  contents:
  - render_page
}

Note that \code{contents} can contain either a list of function names,
or if the functions in a section share a common prefix or suffix, you
can use \code{starts_with("prefix")} and \code{ends_with("suffix")} to
select them all. For more complex naming schemes you can use an aribrary
regular expression with \code{matches("regexp")}. You can also use a leading
\code{-} to exclude matches from a section. By default, these functions that
match multiple topics will exclude topics with keyword "internal". To
include, use (e.g.) \code{starts_with("build_", internal = TRUE)}.

Alternatively, you can selected topics that contain specified concepts with
\code{has_concept("blah")}. Concepts are not currently well-supported by
roxygen2, but may be useful if you write Rd files by hand.

pkgdown will check that all non-internal topics are included on
this page, and will generate a warning if you have missed any.
}

\section{Figures}{


You can control the default rendering of figues by specifying the \code{figures}
field in \code{_pkgdown.yml}. The default settings are equivalent to:\preformatted{figures:
  dev: grDevices::png
  dpi: 96
  dev.args: []
  fig.ext: png
  fig.width: 7.2916667
  fig.height: ~
  fig.retina: 2
  fig.asp: 1.618
}
}

\section{Icons}{

You can optionally supply an icon for each help topic. To do so, you'll
need a top-level \code{icons} directory. This should contain {.png} files
that are either 30x30 (for regular display) or 60x60 (if you want
retina display). Icons are matched to topics by aliases.
}

\examples{
# This example illustrates some important output types
# The following output should be wrapped over multiple lines
a <- 1:100
a

cat("This some text!\\n")
message("This is a message!")
warning("This is a warning!")

# This is a multi-line block
{
  1 + 2
  2 + 2
}

\dontrun{
stop("This is an error!", call. = FALSE)
}

\donttest{
# This code won't generally be run by CRAN. But it
# will be run by pkgdown
b <- 10
a + b
}
}
