% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-site.R
\name{deploy_site_github}
\alias{deploy_site_github}
\title{Deploy a pkgdown site on Travis-CI to Github Pages}
\usage{
deploy_site_github(pkg = ".", install = TRUE,
  tarball = Sys.getenv("PKG_TARBALL", ""),
  ssh_id = Sys.getenv("id_rsa", ""),
  repo_slug = Sys.getenv("TRAVIS_REPO_SLUG", ""),
  commit_message = construct_commit_message(pkg), verbose = FALSE, ...)
}
\arguments{
\item{pkg}{Path to package.}

\item{install}{Optionally, opt-out of automatic installation. This is
necessary if the package you're document is a dependency of pkgdown}

\item{tarball}{The location of the built package tarball. The default Travis
configuration for R packages sets \code{PKG_TARBALL} to this path.}

\item{ssh_id}{The private id to use, a base64 encoded content of the private
pem file. This should \emph{not} be your personal private key. Instead create a
new keypair specifically for deploying the site. The easiest way is to use
\code{travis::use_travis_deploy()}.}

\item{repo_slug}{The \code{user/repo} slug for the repository.}

\item{commit_message}{The commit message to be used for the commit.}

\item{verbose}{Print verbose output}

\item{...}{Additional arguments passed to \code{\link[=build_site]{build_site()}}.}
}
\description{
\code{deploy_site_github()} sets up your SSH keys for deployment, builds the
site with \code{\link[=build_site]{build_site()}}, commits the site to the \code{gh-pages} branch and then pushes
the results back to GitHub. \code{deploy_site_github()} is meant only to be used
by the CI system on Travis, it should not be called locally. See 'Setup' for
details on setting up your repository to use this.
}
\section{Setup}{

For a quick setup, you can use \code{\link[usethis:use_pkgdown_travis]{usethis::use_pkgdown_travis()}}. It  will help you
with the following detailed steps.
\itemize{
\item Add the following to your \code{.travis.yml} file.\preformatted{before_cache: Rscript -e 'remotes::install_cran("pkgdown")'
deploy:
  provider: script
  script: Rscript -e 'pkgdown::deploy_site_github()'
  skip_cleanup: true
}
\item Then you will need to setup your deployment keys. The easiest way is to call
\code{travis::use_travis_deploy()}. This will generate and push the necessary
keys to your GitHub and Travis accounts. See the \href{https://ropenscilabs.github.io/travis/}{travis package website} for more details.
\item Next, make sure that a gh-pages branch exists. The simplest way to do
so is to run the following git commands locally:\preformatted{git checkout --orphan gh-pages
git rm -rf .
git commit --allow-empty -m 'Initial gh-pages commit'
git push origin gh-pages
git checkout master
}

We recommend doing this outside of RStudio (with the project closed) as
from RStudio's perspective you end up deleting all the files and then
re-creating them.
\item If you're using a custom CNAME, make sure you have set the \code{url} in
\code{_pkgdown.yaml}:\preformatted{url: http://pkgdown.r-lib.org
}
}
}

