% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_site}
\alias{build_site}
\title{Build a complete pkgdown website}
\usage{
build_site(
  pkg = ".",
  examples = TRUE,
  run_dont_run = FALSE,
  seed = 1014,
  lazy = FALSE,
  override = list(),
  preview = NA,
  devel = FALSE,
  new_process = !devel,
  install = !devel,
  document = "DEPRECATED"
)
}
\arguments{
\item{pkg}{Path to package.}

\item{examples}{Run examples?}

\item{run_dont_run}{Run examples that are surrounded in \\dontrun?}

\item{seed}{Seed used to initialize so that random examples are
reproducible.}

\item{lazy}{If \code{TRUE}, will only rebuild articles and reference pages
if the source is newer than the destination.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{devel}{Use development or deployment process?

If \code{TRUE}, uses lighter-weight process suitable for rapid
iteration; it will run examples and vignettes in the current process,
and will load code with \code{pkgload::load_all()}.

If \code{FALSE}, will first install the package to a temporary library,
and will run all examples and vignettes in a new process.

\code{build_site()} defaults to \code{devel = FALSE} so that you get high fidelity
outputs when you building the complete site; \code{build_reference()},
\code{build_home()} and friends default to \code{devel = TRUE} so that you can
rapidly iterate during development.}

\item{new_process}{If \code{TRUE}, will run \code{build_site()} in a separate process.
This enhances reproducibility by ensuring nothing that you have loaded
in the current process affects the build process.}

\item{install}{If \code{TRUE}, will install the package in a temporary library
so it is available for vignettes.}

\item{document}{\strong{Deprecated} Use \code{devel} instead.}
}
\description{
\code{build_site()} is a convenient wrapper around six functions:
\itemize{
\item \code{\link[=init_site]{init_site()}}
\item \code{\link[=build_home]{build_home()}}
\item \code{\link[=build_reference]{build_reference()}}
\item \code{\link[=build_articles]{build_articles()}}
\item \code{\link[=build_tutorials]{build_tutorials()}}
\item \code{\link[=build_news]{build_news()}}
}

See the documentation for the each function to learn how to control
that aspect of the site. This page documents options that affect the
whole site.
}
\section{General config}{

\itemize{
\item \code{destination} controls where the site will be generated, defaulting to
\verb{docs/}. Paths are relative to the package root.
\item \code{url} is optional, but strongly recommended.\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{url: https://pkgdown.r-lib.org
}\if{html}{\out{</div>}}

It specifies where the site will be published and is used to allow other
pkgdown sites to link to your site when needed (\code{vignette("linking")}),
generate a \code{sitemap.xml}, automatically generate a \code{CNAME} when
\link[=deploy_site_github]{deploying to github}, generate the metadata needed
rich social "media cards" (\code{vignette("metadata")}), and more.
\item \code{title} overrides the default site title, which is the package name.
It's used in the page title and default navbar.
}
}

\section{Development mode}{

The \code{development} field allows you to generate different sites for the
development and released versions of your package. To use it, you first
need to set the development \code{mode}:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{development:
  mode: auto
}\if{html}{\out{</div>}}
\subsection{Setting development mode}{

The development \code{mode} of a site controls where the site is built,
the colour of the package version in the navbar, the version tooltip,
and whether or not the site is indexed by search engines. There are
four possible modes:
\itemize{
\item \strong{automatic} (\code{mode: auto}): automatically determines the mode based on the
version number:
\itemize{
\item \verb{0.0.0.9000} (\verb{0.0.0.*}): unreleased.
\item four version components: development.
\item everything else -> release.
}
\item \strong{release} (\code{mode: release}), the default. Site is written to \verb{docs/}.
Version in navbar gets the default colouring.
\item \strong{development} (\code{mode: devel}). Site is written to \verb{docs/dev/}.
The navbar version gets a "danger" class and a tooltip stating these are
docs for an in-development version of the package. The \code{noindex} meta tag
is used to ensure that these packages are not indexed by search engines.
\item \strong{unreleased} (\code{mode: unreleased}). Site is written to \verb{docs/}.
Version in navbar gets the "danger" class, and a message indicating the
package is not yet on CRAN.
}

You can override the mode specified in the \verb{_pkgdown.yml} by setting
by setting \code{PKGDOWN_DEV_MODE} to \code{devel} or \code{release}.
}

\subsection{Selective HTML}{

You can selectively show HTML only on the devel or release site by adding
class \code{pkgdown-devel} or \code{pkgdown-release}. This is most easily accessed
from \code{.Rmd} files where you can use pandoc's \verb{<div>} syntax to control
where a block of markdown will display. For example, you can use the
following markdown in your README to only show GitHub install instructions
on the development version of your site:\if{html}{\out{<div class="sourceCode md">}}\preformatted{::: \{.pkgdown-devel\}
You can install the development version of pkgdown from GitHub with:
`remotes::install_github("r-lib/pkgdown")`
:::
}\if{html}{\out{</div>}}

You can use a similar technique to control where badges are displayed.
This markdown show the CRAN status badge on the site for the released
package and the GitHub check status for the development package:\if{html}{\out{<div class="sourceCode md">}}\preformatted{[![CRAN Status](https://www.r-pkg.org/badges/version/pkgdown)]
  (https://cran.r-project.org/package=pkgdown)\{.pkgdown-release\}
[![R-CMD-check](https://github.com/r-lib/pkgdown/workflows/R-CMD-check/badge.svg)]
  (https://github.com/r-lib/pkgdown/actions)\{.pkgdown-devel\}
}\if{html}{\out{</div>}}
}

\subsection{Other options}{

There are three other options that you can control:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{development:
  destination: dev
  version_label: danger
  version_tooltip: "Custom message here"
}\if{html}{\out{</div>}}

\code{destination} allows you to override the default subdirectory used for the
development site; it defaults to \verb{dev/}. \code{version_label} allows you to
override the style used for development (and unreleased) versions of the
package. It defaults to "danger", but you can set to "default", "info", or
"warning" instead. (The precise colours are determined by your bootstrap
theme, but become progressively more eye catching as you go from default
to danger). Finally, you can choose to override the default tooltip with
\code{version_tooltip}.
}
}

\section{Navigation bar}{

You can customise the navigation bar that appears at the top of the page with the \code{navbar} field.
It's made up of two pieces: \code{structure}, which defines the overall layout, and \code{components}, which defines what each piece looks like.
This organisation makes it easy to mix and match pkgdown defaults with your own customisations.

This is the default structure:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{navbar:
  structure:
    left:  [intro, reference, articles, tutorials, news]
    right: [search, github]
}\if{html}{\out{</div>}}

It makes use of the the six built-in components:
\itemize{
\item \code{intro}: "Get Started", which links to a vignette with the same name as the package.
\item \code{reference}, if there are any \code{.Rd} files.
\item \code{articles}, if there are any vignettes or articles.
\item \code{tutorials}, if there any tutorials.
\item \code{news}, if \code{NEWS.md} exists.
\item \code{search}, the search box (see \code{vignette("search")} for more details).
\item \code{github}, a link to the source repository (with an icon), if it can be automatically determined from the \code{DESCRIPTION}.
}

You can use the \code{structure} field to reorganise the navbar without changing the default contents:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{navbar:
  structure:
    left:  [search]
    right: [reference, articles]
}\if{html}{\out{</div>}}

You can use \code{components} to override the default content.
For example, this yaml provides a custom articles menu:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{navbar:
 components:
   articles:
    text: Articles
    menu:
    - text: Category A
    - text: Title A1
      href: articles/a1.html
    - text: Title A2
      href: articles/a2.html
    - text: -------
    - text: "Category B"
    - text: Article B1
      href: articles/b1.html
}\if{html}{\out{</div>}}

Components uses the same syntax as \href{https://bookdown.org/yihui/rmarkdown/rmarkdown-site.html#site-navigation}{RMarkdown menus}.
The elements of \code{menu} can be:
\itemize{
\item A link (\code{text} + \code{href})
\item A heading (just \code{text})
\item A separator (\verb{text: ——–})
}

Instead of text, you can also use the name of an \code{icon}s from \href{https://fontawesome.com/icons?d=gallery}{fontawesome}.
You should also provide a textual description in the \code{aria-label} field for screenreader users.

To add a new component to the navbar, you need to modify both \code{structure} and \code{components}.
For example, the following yaml adds a new "twitter" component that appears to the left of the github icon.\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{navbar:
  structure:
    right: [twitter, github]
  components:
    twitter:
      icon: fa-twitter
      href: http://twitter.com/hadleywickham
      aria-label: Twitter
}\if{html}{\out{</div>}}

Finally, you can add arbitrary HTML to three locations in the navbar:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  includes:
    before_title: <!-- inserted before the package title in the header ->
    before_navbar: <!-- inserted before the navbar links -->
    after_navbar: <!-- inserted after the navbar links -->
}\if{html}{\out{</div>}}

These includes will appear on all screen sizes, and will not be collapsed into the the navbar drop down.

You can also customise the colour scheme of the navbar by using the \code{type}
and \code{bg} parameters. See \code{vignette("customise")} for more details.
}

\section{Footer}{

You can customise the footer with the \code{footer} field.
It's made up of two pieces: \code{structure}, which defines the overall layout, and \code{components}, which defines what each piece looks like.
This organisation makes it easy to mix and match the pkgdown defaults with your own customisations.

This is the default structure:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{footer:
  structure: 
    left: developed_by
    right: built_with
}\if{html}{\out{</div>}}

Which uses two of the three built-in components:
\itemize{
\item \code{developed_by}, a sentence describing the main authors of the package. (See \code{?build_home} if you want to tweak \emph{which} authors appear in the footer.)
\item \code{built_with}, a sentence advertising pkgdown.
\item \code{package}, the name of the package.
}

You can override these defaults with the \code{footer} field.
The example below puts the authors' information on the right along with a legal disclaimer, and puts the pkgdown link on the left.\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{footer:
  structure: 
    left: pkgdown
    right: [authors, legal]
  components:
    legal: Provided without **any warranty**.
}\if{html}{\out{</div>}}

Each side is pasted into a single string (separated by \code{" "}) and then converted from markdown to HTML.
}

\section{Search}{

The \code{search} field controls the built-in search. See \code{vignette("search")}
for details.
}

\section{Template}{

The \code{template} field is mostly used to control the appearance of the site.
See \code{vignette("customise")} for details.

There are two other \code{template} fields that control other aspects of the
site:
\itemize{
\item \code{noindex: true} will suppress indexing of your pages by search engines:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  params:
    noindex: true
}\if{html}{\out{</div>}}
\item \code{google_site_verification} allows you to verify your site with google:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  params:
    google_site_verification: _nn6ile-a6x6lctOW
}\if{html}{\out{</div>}}
\item \code{trailing_slash_redirect: true} will automatically redirect
\code{your-package-url.com} to \verb{your-package-url.com/}, using a JS script
added to the \verb{<head>} of the home page. This is useful in certain
redirect scenarios.\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  trailing_slash_redirect: true
}\if{html}{\out{</div>}}
}
}

\section{Analytics}{


To capture usage of your site with a web analytics platform, you can make
use of the \code{includes} field to add the HTML supplied to you by the platform.
Typically these are either placed \code{after_body} or \code{in_header}. I include
a few examples below, but I highly recommend getting the recommended HTML
directly from the platform.
\itemize{
\item \href{https://counter.dev}{counter.dev}\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  includes:
    after_body: >
      <script>if(!sessionStorage.getItem("_swa")&&document.referrer.indexOf(location.protocol+"//"+location.host)!== 0)\{
     fetch("https://counter.dev/track?"+new URLSearchParams(\{referrer:document.referrer,screen:screen.width+"x"+screen.height,user:"\{YOUR USERNAME\}",
   utcoffset:"1"\}))\};sessionStorage.setItem("_swa","1");</script>
}\if{html}{\out{</div>}}
\item \href{https://www.goatcounter.com}{GoatCounter}:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  includes:
    after_body: >
      <script data-goatcounter="https://\{YOUR CODE\}.goatcounter.com/count" data-goatcounter-settings="\{YOUR SETTINGS\}" async src="https://gc.zgo.at/count.js"></script>
}\if{html}{\out{</div>}}
\item \href{https://analytics.google.com/analytics/web/}{Google analytics}:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{template:
  includes:
    in_header: |
       <!-- Global site tag (gtag.js) - Google Analytics -->
       <script async src="https://www.googletagmanager.com/gtag/js?id=\{YOUR TRACKING ID\}"#' ></script>
       <script>
         window.dataLayer = window.dataLayer || [];
         function gtag()\{dataLayer.push(arguments);\}
         gtag('js', new Date());

         gtag('config', '\{YOUR TRACKING ID\}');
       </script>
}\if{html}{\out{</div>}}
\item \href{https://plausible.io}{plausible.io}:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{templates:
  includes:
    in_header: |
      <script defer data-domain="\{YOUR DOMAIN\}" src="https://plausible.io/js/plausible.js"></script>
}\if{html}{\out{</div>}}
}
}

\section{Source repository}{

Use the \code{repo} field to override pkgdown's automatically discovery
of your source repository. This is used in the navbar, on the homepage,
in articles and reference topics, and in the changelog (to link to issue
numbers and user names). pkgdown can automatically figure out the necessary
URLs if you link to a GitHub or GitLab repo in your \code{BugReports} or \code{URL}
field.

Otherwise, you can supply your own in the \code{repo} field:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{repo:
  url:
    home: https://github.com/r-lib/pkgdown/
    source: https://github.com/r-lib/pkgdown/blob/HEAD/
    issue: https://github.com/r-lib/pkgdown/issues/
    user: https://github.com/
}\if{html}{\out{</div>}}
\itemize{
\item \code{home}: path to package home on source code repository.
\item \verb{source:}: path to source of individual file in default branch.
\item \code{issue}: path to individual issue.
\item \code{user}: path to user.
}

The varying components (e.g. path, issue number, user name) are pasted on
the end of these URLs so they should have trailing \code{/}s.

pkgdown can automatically link to Jira issues as well if specify both a
custom \code{issue} URL as well Jira project names to auto-link in
\code{jira_projects}. You can specify as many projects as you would like:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{repo:
  jira_projects: [this_project, another_project]
  url:
    issue: https://jira.organisation.com/jira/browse/
}\if{html}{\out{</div>}}

pkgdown defaults to using the "HEAD" branch for source file URLs. This can
be configured to use a specific branch when linking to source files by
specifying a branch name:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{repo:
  branch: devel
}\if{html}{\out{</div>}}
}

\section{Deployment (\code{deploy})}{

There is a single \code{deploy} field
\itemize{
\item \code{install_metadata} allows you to install package index metadata into
the package itself. Normally this metadata is made available on the
published site; installing it into your package means that it's
available for autolinking even if your website is not reachable at build
time (e.g. because behind a firewall or requires auth).\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{deploy:
  install_metadata: true
}\if{html}{\out{</div>}}
}
}

\section{Redirects}{

If you change the structure of your documentation (by renaming vignettes or help topics) you can setup redirects from the old content to the new content.
One or several now-absent pages can be redirected to a new page (or to a new section of a new page).
This works by creating a html page that performs a "meta refresh", which isn't the best way of doing a redirect but works everywhere that you might deploy your site.

The syntax is the following, with old paths on the left, and new paths or URLs on the right.\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{redirects:
  - ["articles/old-vignette-name.html", "articles/new-vignette-name.html"]
  - ["articles/another-old-vignette-name.html", "articles/new-vignette-name.html"]
  - ["articles/yet-another-old-vignette-name.html", "https://pkgdown.r-lib.org/dev"]
}\if{html}{\out{</div>}}

If for some reason you choose to redirect an existing page make sure to exclude it from the search index, see \code{?build_search}.
}

\section{Options}{

Users with limited internet connectivity can disable CRAN checks by setting
\code{options(pkgdown.internet = FALSE)}. This will also disable some features
from pkgdown that requires an internet connectivity. However, if it is used
to build docs for a package that requires internet connectivity in examples
or vignettes, this connection is required as this option won't apply on them.

Users can set a timeout for \code{build_site(new_process = TRUE)} with
\code{options(pkgdown.timeout = Inf)}, which is useful to prevent stalled builds from
hanging in cron jobs.
}

\examples{
\dontrun{
build_site()

build_site(override = list(destination = tempdir()))
}
}
