% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.gen.R
\name{plr}
\alias{plr}
\title{Perform the paired log-rank test.}
\usage{
plr(dat, A.name = "As", Y.name = "Ys", D.name = "Ds")
}
\arguments{
\item{dat}{a data.frame of left-truncated right-censored data.}

\item{A.name}{the name of the truncation time variable in \code{dat}.}

\item{Y.name}{the name of the survival time variable in \code{dat}.}

\item{D.name}{the name of the event indicator in \code{dat}.}
}
\value{
a list containing the test statistic and the p-value of the paired log-rant test.
}
\description{
Perform the paired log-rank test on the truncation times and the residual survival times to check the stationarity assumption (uniform truncation assumption) of the left-truncated right-censored data.
}
\examples{
dat = sim.ltrc(n = 100, distr.A = "weibull")$dat
plr(dat)
}
\references{
Jung, S.H. (1999). Rank tests for matched survival data. \emph{Lifetime Data Analysis, 5(1):67-79}.
}

