% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toeplitz.R
\docType{data}
\name{toeplitz}
\alias{toeplitz}
\title{Simulated 'Toeplitz' Data}
\format{
An object of class \code{standardGeneric} of length 1.
}
\usage{
data(toeplitz)
}
\description{
Some simulated data with a causal relationship between features X and target
y. The first 10 of the 25 features have a decreasing causal effect on y
while the remaining 15 do not have causal effect.
The variables in X follow a normal distribution with mean zero while
the covariance matrix follows a 'Toeplitz' matrix.
}
\examples{
# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit cv.plasso to the data
\donttest{p.cv = plasso::cv.plasso(X,y)}

}
\keyword{datasets}
