% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_plater_format.R
\name{check_plater_format}
\alias{check_plater_format}
\title{Check whether a file is in plater format.}
\usage{
check_plater_format(file, sep = ",")
}
\arguments{
\item{file}{The path of the file to check.}

\item{sep}{The character used to separate columns in the file (e.g. "," or ";"). 
Defaults to ",".}
}
\value{
Displays a number of messages as it checks the file. Will stop with
a descriptive error message if the file is not formatted correctly.
}
\description{
Runs the provided file through a number of diagnostics to determine whether
it is a valid plater format file and displays information about any 
deficiencies found.
}
\examples{
file_path <- system.file("extdata", "example-1.csv", package = "plater")

data <- check_plater_format(file_path)
}
