% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.fitmixture.R
\name{summary.fitmixture}
\alias{summary.fitmixture}
\title{Summarize a "fitmixture" Object}
\usage{
\method{summary}{fitmixture}(object, ...)
}
\arguments{
\item{object}{the result of a call to \code{fit_mixture()}}

\item{...}{for additional summary arguments}
}
\value{
a list of results from the function called depending on the "family" specified.
\item{call}{the matched call}
\item{family}{the assumed type of (outcome) regression model}
\item{coefficients}{a matrix with the outcome model's coefficient estimates, standard errors, t or z values, and p-values}
\item{m.coefficients}{a matrix with the correct match model's coefficient estimates and standard errors}
\item{avgcmr}{the average correct match rate among all records}
\item{match.prob}{the correct match probabilities for all observations}
\item{dispersion}{the dispersion parameter estimate when the family is a Generalized Linear Model}
}
\description{
Summarize results from a \code{fit_mixture()} object
}
\examples{
## commonness score of first and last names used for linkage
mformula <- ~commf + comml
## hand-linked records are considered "safe" matches
safematches <- ifelse(lifem$hndlnk =="Hand-Linked At Some Level", TRUE, FALSE)
## overall mismatch rate in the data set is assumed to be ~ 0.05
mrate <- 0.05
fit <- fit_mixture(age_at_death ~ poly(unit_yob, 3, raw = TRUE), data = lifem,
                   family = "gaussian", mformula, safematches, mrate)

summary(fit)

}
