% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalingPlot.R
\name{scalingPlot}
\alias{scalingPlot}
\title{Graphs estimated scale values by integers of the LMA (nominal) model}
\usage{
scalingPlot(model.fit)
}
\arguments{
\item{model.fit}{Output from a nominal model}
}
\value{
plots of estimated scale values by integers
}
\description{
This function plots the estimated item scale values (i.e, nus) by integers
 to see shape of scaling of the categories.A linear regression is overlaid
 in the plot to help assess linearity. The dashed red line overlaid in the
 plot is the linear regression line of the scale values on integers.
}
\examples{

#--- some data, 2 items from depression, anxiety and stress scales
#    for 250 cases out of possible 1000
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "a1", "a2", "s1", "s2")]
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=6, ncol=1)
 n1 <- ple.lma(inData, model.type="nominal", inItemTraitAdj, inTraitAdj, tol=1e-03)
 scalingPlot(n1)

}
