% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_up.R
\name{set.up}
\alias{set.up}
\title{Sets up the data based on input data and model specifications}
\usage{
set.up(
  inData,
  model.type,
  inTraitAdj = NULL,
  inItemTraitAdj = NULL,
  tol = NULL,
  starting.sv = NULL,
  starting.phi = NULL
)
}
\arguments{
\item{inData}{A person x item Data frame with response patterns}

\item{model.type}{Type of model to be fit}

\item{inTraitAdj}{Trait x Trait adjacency matrix (NULL for independence)}

\item{inItemTraitAdj}{Item x Trait adjacency matrix (NULL for independence)}

\item{tol}{Tolerence for deteriming convergence (default: 1e-06)}

\item{starting.sv}{Starting category scale values/fixed scores (default: sum equal to zero and sum of squares equal to 1)}

\item{starting.phi}{optional: Starting phi matrix (default:  identity matrix)}
}
\value{
PersonByItem   inData (rows are response patterns)

TraitByTrait   Trait x Trait adjacency matrix

ItemByTrait    Item x Trait adjacency matrix

item.by.trait  Need for re-scaling phi.mat

starting.sv		An item by number of category matrix with starting values for scale values for nominal model and fixed category scores for gpcm and rasch models

ItemNames      Names of items in inData and PersonByItem

LambdaName     Short list of lambda names needed for item regressions

NuName         Short list of nu names names needed for item regressions

LambdaNames    Long list of lambdas using in Master data set

NuNames        Long list of nu using in Master data set

PhiNames       Names of the unique phi parameters

npersons       Number of individual or persons in data

nitems         Number of items

ncat         	Number of categories

nless          Number of unique lambdas and unique nus

ntraits        Number of traits

Maxnphi        Number of phis to estimate

Nstack         Length of master data set

pq.mat         An array used to computed (weighted) rest-scores

Phi.mat        A number of traits x number of traits Phi matrix (defual: the identity matrix)

Master         Master data set formated for input to to mlogit

tol            Tolerence for deteriming convergence
}
\description{
This function sets up the data and sets constants that are essentially
the same for all models. This is used within the main wrapper function 
`ple.lma', but can also be run independently. If a user wants to run 
the functions `fit.independence', `fit.rasch', `fit.gpcm', or `fit.nominal',
the set up function should be run prior to using these functions to 
create required input. Such an approach can speed up replication studies 
because `set.up' would only need to be run once and the response vector 
(i.e., named `y') in the Master data frame be replaced by a new one.
}
\examples{
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]

 #--- to set data up for model of independence
 ind.setup <- set.up(inData, model.type="independence")

 #--- for model specification for uni-dimensional models
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

 i.setup <- set.up(inData, model.type='independence')
 
 r.setup <- set.up(inData, model.type='rasch', inTraitAdj,
                  inItemTraitAdj)

 g.setup <- set.up(inData, model.type='gpcm', inTraitAdj,
                  inItemTraitAdj)

 n.setup <- set.up(inData, model.type='nominal', inTraitAdj,
                  inItemTraitAdj)

}
