% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_ldv.R
\name{pldv}
\alias{pldv}
\title{Panel estimators for limited dependent variables}
\usage{
pldv(formula, data, subset, weights, na.action, model = c("fd", "random",
  "pooling"), index = NULL, R = 20, start = NULL, lower = 0,
  upper = +Inf, objfun = c("lsq", "lad"), sample = c("cens",
  "trunc"), ...)
}
\arguments{
\item{formula}{a symbolic description for the model to be
estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{lm},}

\item{weights}{see \code{lm},}

\item{na.action}{see \code{lm},}

\item{model}{one of \code{"fd"}, \code{"random"} or \code{"pooling"},}

\item{index}{the indexes, see \code{\link[=pdata.frame]{pdata.frame()}},}

\item{R}{the number of points for the gaussian quadrature,}

\item{start}{a vector of starting values,}

\item{lower}{the lower bound for the censored/truncated dependent
variable,}

\item{upper}{the upper bound for the censored/truncated dependent
variable,}

\item{objfun}{the objective function for the fixed effect model,
one of \code{"lsq"} for least squares and \code{"lad"} for least absolute
deviations,}

\item{sample}{\code{"cens"} for a censored (tobit-like) sample,
\code{"trunc"} for a truncated sample,}

\item{\dots}{further arguments.}
}
\value{
An object of class \code{c("plm","panelmodel")}.
}
\description{
Fixed and random effects estimators for truncated or censored
limited dependent variable
}
\details{
\code{pldv} computes two kinds of models : maximum likelihood estimator
with an assumed normal distribution for the individual effects and
a LSQ/LAD estimator for the first-difference model.
}
\references{
\insertRef{HONO:92}{plm}
}
\author{
Yves Croissant
}
\keyword{regression}
