% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cips.R
\name{cipstest}
\alias{cipstest}
\title{Cross-sectionally Augmented IPS Test for Unit Roots in Panel Models}
\usage{
cipstest(
  x,
  lags = 2,
  type = c("trend", "drift", "none"),
  model = c("cmg", "mg", "dmg"),
  truncated = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"pseries"},}

\item{lags}{integer, lag order for Dickey-Fuller augmentation,}

\item{type}{one of \code{"trend"} (default), \code{"drift"}, \code{"none"},}

\item{model}{one of \code{"cmg"} (default), \code{"mg"}, \code{"dmg"},}

\item{truncated}{logical, specifying whether to calculate the
truncated version of the test (default: \code{FALSE}),}

\item{\dots}{further arguments passed to \code{critvals.cips}
(non-exported function).}
}
\value{
An object of class \code{"htest"}.
}
\description{
Cross-sectionally augmented Im, Pesaran and Shin (IPS) test for
unit roots in panel models.
}
\details{
Pesaran's \insertCite{pes07}{plm} cross-sectionally augmented version of
the IPS unit root test \insertCite{IM:PESAR:SHIN:03}{plm} (H0: \code{pseries}
has a unit root) is a so-called second-generation panel unit root test: it
is in fact robust against cross-sectional dependence, provided that the default
\code{model="cmg"} is calculated. Else one can obtain the standard
(\code{model="mg"}) or cross-sectionally demeaned (\code{model="dmg"})
versions of the IPS test.

Argument \code{type} controls how the test is executed:
\itemize{
\item \code{"none"}: no intercept, no trend (Case I in \insertCite{pes07}{plm}),
\item \code{"drift"}: with intercept, no trend (Case II),
\item \code{"trend"} (default): with intercept, with trend (Case III).
}
}
\examples{

data("Produc", package = "plm")
Produc <- pdata.frame(Produc, index=c("state", "year"))
## check whether the gross state product (gsp) is trend-stationary
cipstest(Produc$gsp, type = "trend")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=purtest]{purtest()}}, \code{\link[=phansi]{phansi()}}
}
\author{
Giovanni Millo
}
\keyword{htest}
