% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_roc.R
\name{melt_roc}
\alias{melt_roc}
\title{Transform biomarkers stored as wide to long}
\usage{
melt_roc(data, d, m, names = NULL)
}
\arguments{
\item{data}{Data frame containing disease status and biomarkers stored in columns}

\item{d}{Column containing binary disease status. Can be a column name or index}

\item{m}{Vector of column names or indices identifying biomarkers}

\item{names}{Optional vector of names to assign to the biomarkers. If NULL, names will be taken from the column names}
}
\value{
A data frame in long format with three columns: D = binary disease status, M = biomarker value, and name = biomarker name
}
\description{
Multiple biomarkers measured on the same subjects are often stored as multiple columns in a data frame. This is a convenience function that transforms the data into long format, suitable for use with ggplot and \link{geom_roc}
}
\examples{
D.ex <- rbinom(50, 1, .5)
widedata <- data.frame(D = D.ex, M1 = rnorm(50, mean = D.ex, sd = 1), 
   M2 = rnorm(50, mean = D.ex, sd = .5))
longdata <- melt_roc(widedata, "D", c("M1", "M2"))
ggplot(longdata, aes(d = D, m = M, color = name)) + geom_roc()

}
