% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getFigCoords}
\alias{getFigCoords}
\title{Get the figure region as coordinates of the current plot region, 
or as corrdinates of the figure region.}
\usage{
getFigCoords(input = "f")
}
\arguments{
\item{input}{Text string: 'f' (figure, default), 'p' (plot region), 
'hf' (half way figure region), or 'hp' (half way plot region)}
}
\value{
A vector of the form c(x1, x2, y1, y2) giving the 
boundaries of the figure region as coordinates of the current 
plot region.
}
\description{
Get the figure region as coordinates of the current plot region, 
or as corrdinates of the figure region.
}
\examples{
# setup plot region:
emptyPlot(1,1, bty='o')
fc <- getFigCoords()
pc <- getFigCoords('p')
arrows(x0=pc[c(1,2,1,2)], x1=fc[c(1,2,1,2)],
    y0=pc[c(3,3,4,4)], y1=fc[c(3,3,4,4)], xpd=TRUE)

# Same plot with different axis:
emptyPlot(c(250,500),c(331, 336), bty='o')
fc <- getFigCoords()
pc <- getFigCoords('p')
arrows(x0=pc[c(1,2,1,2)], x1=fc[c(1,2,1,2)],
    y0=pc[c(3,3,4,4)], y1=fc[c(3,3,4,4)], xpd=TRUE)
hc <-  getFigCoords('h')

# other options:
# 1. center of figure region:
abline(v=getFigCoords('hf')[1], col='blue', xpd=TRUE)
abline(h=getFigCoords('hf')[2], col='blue', xpd=TRUE)
# 2. center of plot region:
abline(v=getFigCoords('hp')[1], col='red', lty=3)
abline(h=getFigCoords('hp')[2], col='red', lty=3)

}
\seealso{
\code{\link{getCoords}}, \code{\link{getProps}}

Other Functions for plotting: 
\code{\link{addInterval}()},
\code{\link{add_bars}()},
\code{\link{add_n_points}()},
\code{\link{alphaPalette}()},
\code{\link{alpha}()},
\code{\link{check_normaldist}()},
\code{\link{color_contour}()},
\code{\link{dotplot_error}()},
\code{\link{drawDevArrows}()},
\code{\link{emptyPlot}()},
\code{\link{errorBars}()},
\code{\link{fill_area}()},
\code{\link{getCoords}()},
\code{\link{getProps}()},
\code{\link{gradientLegend}()},
\code{\link{legend_margin}()},
\code{\link{marginDensityPlot}()},
\code{\link{plot_error}()},
\code{\link{plot_image}()},
\code{\link{plotsurface}()},
\code{\link{sortBoxplot}()}
}
\author{
Jacolien van Rij
}
\concept{Functions for plotting}
