% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{raster2uri}
\alias{raster2uri}
\title{Convert a raster object to a data URI}
\usage{
raster2uri(r, ...)
}
\arguments{
\item{r}{an object coercable to a raster object via \code{\link{as.raster}()}}

\item{...}{arguments passed onto \code{\link{as.raster}()}.}
}
\description{
Convenient embedding images via \code{\link{layout}()}
\href{images}{https://plot.ly/r/reference/#layout-images}.
}
\examples{

# a red gradient (from ?as.raster)
r <- as.raster(matrix(hcl(0, 80, seq(50, 80, 10)), nrow = 4, ncol = 5))
plot(r)

# embed the raster as an image
plot_ly(x = 1, y = 1) \%>\% 
  layout(
    images = list(list(
     source = raster2uri(r),
     xref = "paper", 
     yref = "paper", 
     x = 0, y = 0, 
     sizex = 0.5, sizey = 0.5, 
     xanchor = "left", yanchor = "bottom"
  ))
 ) 
}
\author{
Carson Sievert
}
