% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_func.R
\name{pls}
\alias{pls}
\title{Run partial least squares analysis}
\usage{
pls(X, Y, n_perm = 100, n_boot = 100, scale = T, verbose = F,
  alpha = 0.05)
}
\arguments{
\item{X}{A matrix of m observations on n_x variables.}

\item{Y}{A matrix of m observations on n_y dimensions.}

\item{n_perm}{Number of permutation iterations. Default is 100.}

\item{n_boot}{Number of bootstrap iterations. Default is 100.}

\item{scale}{Scaling of X and Y (Boolean).}

\item{verbose}{Provides additional output.}

\item{alpha}{The significance level for permutation testing.}
}
\value{
A plsr Object.
}
\description{
This is the main function of the plsr package. It will calculate a partial least squares solution
for the provided data and perform permutation testing and bootstrapping on the resulting latent variables.
Results will be saved as a plsr object.
}
\examples{
X = matrix(rnorm(300), ncol = 3)
Y = matrix(rnorm(1000), ncol = 10)
pls(X,Y)
pls(X,Y, n_perm = 10, n_boot = 10)
\donttest{
#running pls function on included data of the package
plsr_obj=pls(rating_data,tracking_data,1000,1000)
#inspecting results:
plot(plsr_obj)
summary(plsr_obj)
}
}
