% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R
\name{pr_run}
\alias{pr_run}
\title{Start a server using \code{plumber} object}
\usage{
pr_run(pr, host = "127.0.0.1", port = getOption("plumber.port", NULL))
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{host}{A string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on. "0.0.0.0" represents
all IPv4 addresses and "::/0" represents all IPv6 addresses.}

\item{port}{A number or integer that indicates the server port that should
be listened on. Note that on most Unix-like systems including Linux and
Mac OS X, port numbers smaller than 1025 require root privileges.}
}
\description{
\code{port} does not need to be explicitly assigned.
}
\examples{
\dontrun{
pr() \%>\%
  pr_run()

pr() \%>\%
  pr_run(port = 5762, debug = TRUE)
}

}
